/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.menu;

import divinerpg.client.slot.InfusionTableResultSlot;
import divinerpg.recipe.InfusionTableRecipe;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.MenuTypeRegistry;
import divinerpg.registries.RecipeRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class InfusionTableMenu
extends AbstractContainerMenu {
    public InfusionInventory inputs = new InfusionInventory(this);
    public ResultContainer output = new ResultContainer();
    private final ContainerLevelAccess access;
    private final Player player;

    public InfusionTableMenu(int screenId, Inventory plInventory, ContainerLevelAccess functionCaller) {
        super((MenuType)MenuTypeRegistry.INFUSION_TABLE.get(), screenId);
        this.access = functionCaller;
        this.player = plInventory.player;
        this.addSlot(new Slot((Container)this.inputs, 0, 18, 39));
        this.addSlot(new Slot((Container)this.inputs, 1, 18, 59));
        this.addSlot(new InfusionTableResultSlot(this.player, this.inputs, this.output, 0, 63, 49));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)plInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)plInventory, k, 8 + k * 18, 142));
        }
    }

    public InfusionTableMenu(int id, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(id, inventory, ContainerLevelAccess.NULL);
    }

    public void slotsChanged(Container inventory) {
        this.access.execute((world, pos) -> this.slotChangedCraftingGrid((Level)world, this.player, this.inputs, this.output));
    }

    protected void slotChangedCraftingGrid(Level world, Player player, InfusionInventory inv, ResultContainer craftResult) {
        Optional recipeOptional = world.getServer().getRecipeManager().getRecipeFor((RecipeType)RecipeRegistry.Types.INFUSION_TABLE_RECIPE_TYPE.get(), (RecipeInput)CraftingInput.of((int)1, (int)2, List.of(inv.getItem(0), inv.getItem(1))), world);
        if (recipeOptional.isPresent()) {
            ItemStack output = ((InfusionTableRecipe)((RecipeHolder)recipeOptional.get()).value()).output().copy();
            craftResult.setItem(2, output);
        } else {
            craftResult.setItem(2, ItemStack.EMPTY);
        }
    }

    public boolean stillValid(Player player) {
        return InfusionTableMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)BlockRegistry.infusionTable.get()));
    }

    public void removed(Player player) {
        super.removed(player);
        this.output.setItem(2, ItemStack.EMPTY);
        this.access.execute((world, pos) -> this.clearContainer(player, (Container)this.inputs));
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.output && super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            stack = slotStack.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(slotStack, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, stack);
                this.inputs.setItem(index, slotStack);
            } else if (index != 0 && index != 1 ? index < 39 && !this.moveItemStackTo(slotStack, 0, 2, false) : !this.moveItemStackTo(slotStack, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return stack;
    }

    public static class InfusionInventory
    implements CraftingContainer {
        private final NonNullList<ItemStack> stackList = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        private final AbstractContainerMenu eventListener;

        public InfusionInventory(AbstractContainerMenu container) {
            this.eventListener = container;
        }

        public int getContainerSize() {
            return 3;
        }

        public boolean isEmpty() {
            for (ItemStack stack : this.stackList) {
                if (stack.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int index) {
            return index >= this.getContainerSize() || index < 0 ? ItemStack.EMPTY : (ItemStack)this.stackList.get(index);
        }

        public ItemStack removeItemNoUpdate(int index) {
            return ContainerHelper.takeItem(this.stackList, (int)index);
        }

        public ItemStack removeItem(int index, int count) {
            ItemStack stack = ContainerHelper.removeItem(this.stackList, (int)index, (int)count);
            if (!stack.isEmpty()) {
                this.eventListener.slotsChanged((Container)this);
            }
            return stack;
        }

        public void setItem(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.eventListener.slotsChanged((Container)this);
        }

        public void setChanged() {
        }

        public boolean stillValid(Player p_18946_) {
            return false;
        }

        public void clearContent() {
            this.stackList.clear();
        }

        public void fillStackedContents(StackedContents recipeItemHelper) {
            for (ItemStack stack : this.stackList) {
                recipeItemHelper.accountStack(stack);
            }
        }

        public int getWidth() {
            return 3;
        }

        public int getHeight() {
            return 1;
        }

        public List<ItemStack> getItems() {
            return this.stackList;
        }
    }
}

