/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.arcana.EntityFyracryx;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelFyracryx
extends EntityModel<EntityFyracryx> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("fyracryx");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;

    public ModelFyracryx(EntityRendererProvider.Context context) {
        ModelPart r = context.bakeLayer(LAYER_LOCATION);
        this.root = r.getChild("root");
        this.head = this.root.getChild("head");
        this.leg0 = this.root.getChild("leg0");
        this.leg1 = this.root.getChild("leg1");
        this.leg2 = this.root.getChild("leg2");
        this.leg3 = this.root.getChild("leg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)-1.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-4.5f, -4.0f, -4.0f, 9.0f, 7.0f, 4.0f, CubeDeformation.NONE).texOffs(0, 36).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 2.0f, CubeDeformation.NONE).texOffs(26, 17).addBox(-4.5f, -7.0f, -5.0f, 3.0f, 3.0f, 4.0f, CubeDeformation.NONE).texOffs(26, 17).mirror().addBox(1.5f, -7.0f, -5.0f, 3.0f, 3.0f, 4.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 0).addBox(-3.5f, -1.0f, -6.5f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 0).mirror().addBox(2.5f, -1.0f, -6.5f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-5.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(42, 0).mirror().addBox(0.0f, 0.0f, -2.0f, 3.0f, 6.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)8.0f, (float)1.5708f, (float)0.3927f, (float)0.0f));
        body.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(40, 17).mirror().addBox(0.0f, -5.0f, -3.0f, 1.0f, 3.0f, 3.0f, CubeDeformation.NONE).mirror(false).texOffs(40, 17).addBox(-5.0f, -5.0f, -3.0f, 1.0f, 3.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0f, (float)-4.5f, (float)9.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("body_r3", CubeListBuilder.create().texOffs(40, 36).mirror().addBox(0.0f, -5.0f, -3.0f, 1.0f, 3.0f, 5.0f, CubeDeformation.NONE).mirror(false).texOffs(40, 36).addBox(-5.0f, -5.0f, -3.0f, 1.0f, 3.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0f, (float)-5.0f, (float)1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("body_r4", CubeListBuilder.create().texOffs(42, 0).addBox(-3.0f, 0.0f, -2.0f, 3.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)8.0f, (float)1.5708f, (float)-0.3927f, (float)0.0f));
        body.addOrReplaceChild("body_r5", CubeListBuilder.create().texOffs(26, 10).addBox(-2.0f, 1.0f, -2.0f, 4.0f, 2.0f, 5.0f, CubeDeformation.NONE).texOffs(0, 24).addBox(-3.5f, -7.0f, -3.0f, 7.0f, 8.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)7.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("body_r6", CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, -5.0f, -3.0f, 2.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)6.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("body_r7", CubeListBuilder.create().texOffs(22, 24).addBox(-1.0f, -5.0f, -3.0f, 2.0f, 4.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("body_r8", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -7.0f, -3.0f, 8.0f, 8.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(16, 36).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)-3.0f, (float)-7.0f, (float)5.5f));
        root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(16, 36).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)3.0f, (float)-7.0f, (float)5.5f));
        root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 44).addBox(-1.5f, -1.0f, -2.0f, 4.0f, 8.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-4.0f, (float)-7.0f, (float)-3.0f));
        root.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 44).mirror().addBox(-2.5f, -1.0f, -2.0f, 4.0f, 8.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)4.0f, (float)-7.0f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityFyracryx entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.leg0.xRot = this.leg3.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg1.xRot = this.leg2.xRot = -this.leg0.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

