/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;

public class ModelLeorna<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("leorna");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart a;
    private final ModelPart Bar1;
    private final ModelPart Bar2;
    private final ModelPart Bar3;
    private final ModelPart Bar4;
    private final ModelPart Box;

    public ModelLeorna(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.rightarm = root.getChild("rightarm");
        this.leftarm = root.getChild("leftarm");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.a = root.getChild("a");
        this.Bar1 = root.getChild("Bar1");
        this.Bar2 = root.getChild("Bar2");
        this.Bar3 = root.getChild("Bar3");
        this.Bar4 = root.getChild("Bar4");
        this.Box = root.getChild("Box");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 13).mirror().addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(40, 13).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(40, 13).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 13).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("a", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Bar1", CubeListBuilder.create().texOffs(0, 29).mirror().addBox(0.0f, 0.0f, 0.0f, 24.0f, 2.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-12.0f, (float)9.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("Bar2", CubeListBuilder.create().texOffs(0, 29).mirror().addBox(0.0f, 0.0f, 0.0f, 24.0f, 2.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-12.0f, (float)0.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("Bar3", CubeListBuilder.create().texOffs(0, 29).mirror().addBox(0.0f, 0.0f, 0.0f, 24.0f, 2.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-12.0f, (float)3.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("Bar4", CubeListBuilder.create().texOffs(0, 29).mirror().addBox(0.0f, 0.0f, 0.0f, 24.0f, 2.0f, 1.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-12.0f, (float)6.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("Box", CubeListBuilder.create().texOffs(33, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 4.0f, 12.0f, 3.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-2.0f, (float)-1.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightarm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.leftarm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.rightleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leftleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.a.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Bar1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Bar2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Bar3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Bar4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Box.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

