/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelParatiku<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("paratiku");
    private final ModelPart body;
    private final ModelPart rightWing;
    private final ModelPart rightWingTip;
    private final ModelPart leftWing;
    private final ModelPart leftWingTip;

    public ModelParatiku(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.rightWing = this.body.getChild("rightWing");
        this.rightWingTip = this.rightWing.getChild("rightWingTip");
        this.leftWing = this.body.getChild("leftWing");
        this.leftWingTip = this.leftWing.getChild("leftWingTip");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -11.0f, -5.5f, 14.0f, 14.0f, 10.0f, CubeDeformation.NONE).texOffs(0, 36).addBox(-4.0f, -9.0f, -7.5f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE).texOffs(0, 0).mirror().addBox(2.5f, 0.0f, -6.5f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 0).addBox(-4.5f, 0.0f, -6.5f, 2.0f, 6.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("feet", CubeListBuilder.create().texOffs(24, 36).addBox(-4.5f, -2.0f, -0.5f, 3.0f, 4.0f, 0.0f, CubeDeformation.NONE).texOffs(30, 36).addBox(1.5f, -2.0f, -0.5f, 3.0f, 4.0f, 0.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create(), PartPose.offset((float)-1.5f, (float)0.0f, (float)0.0f));
        rightWing.addOrReplaceChild("rightWing_r1", CubeListBuilder.create().texOffs(24, 24).addBox(-8.0f, -6.0f, 0.0f, 8.0f, 10.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.5f, (float)-2.0f, (float)4.5f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition rightWingTip = rightWing.addOrReplaceChild("rightWingTip", CubeListBuilder.create(), PartPose.offset((float)-10.0f, (float)-6.0f, (float)7.5f));
        rightWingTip.addOrReplaceChild("rightWingTip_r1", CubeListBuilder.create().texOffs(0, 24).addBox(-17.6568f, -6.0f, 5.6569f, 12.0f, 12.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)7.5f, (float)4.0f, (float)-3.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create(), PartPose.offset((float)1.5f, (float)0.0f, (float)0.0f));
        leftWing.addOrReplaceChild("leftWing_r1", CubeListBuilder.create().texOffs(24, 24).mirror().addBox(0.0f, -6.0f, 0.0f, 8.0f, 10.0f, 0.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-2.0f, (float)4.5f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition leftWingTip = leftWing.addOrReplaceChild("leftWingTip", CubeListBuilder.create(), PartPose.offset((float)10.0f, (float)-6.0f, (float)7.5f));
        leftWingTip.addOrReplaceChild("leftWingTip_r1", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(5.6569f, -6.0f, 5.6569f, 12.0f, 12.0f, 0.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)-7.5f, (float)4.0f, (float)-3.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xRot = headPitch * ((float)Math.PI / 180);
        this.leftWing.yRot = Mth.cos((float)ageInTicks) * (float)Math.PI * 0.1f;
        this.leftWingTip.yRot = this.leftWing.yRot * 0.5f;
        this.rightWing.yRot = -this.leftWing.yRot;
        this.rightWingTip.yRot = -this.leftWingTip.yRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

