/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.arcana;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;

public class ModelSkyre<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("skyre");
    private final ModelPart Skull;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart Body;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;

    public ModelSkyre(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Skull = root.getChild("Skull");
        this.LeftArm = root.getChild("LeftArm");
        this.RightArm = root.getChild("RightArm");
        this.Body = root.getChild("Body");
        this.LeftLeg = root.getChild("LeftLeg");
        this.RightLeg = root.getChild("RightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("Skull", CubeListBuilder.create().texOffs(0, 23).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(30, 6).addBox(-3.0f, -6.0f, -6.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(36, 34).addBox(0.0f, -2.0f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(24, 28).addBox(1.0f, 1.0f, -8.0f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(48, 28).addBox(1.01f, 1.0f, -8.0f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)12.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(10, 35).addBox(-2.0f, -2.0f, -2.0f, 2.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 47).addBox(-1.0f, 1.0f, -8.0f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(24, 47).addBox(-1.01f, 1.0f, -8.0f, 0.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)12.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 12).addBox(-4.0f, -9.0f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -6.0f, -4.0f, 10.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 23).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(32, 15).addBox(-2.0f, -1.0f, -2.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)19.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(42, 15).addBox(-1.0f, -1.0f, -2.0f, 3.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)19.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Skull.yRot = netHeadYaw / 57.295776f;
        this.Skull.xRot = headPitch / 57.295776f;
        this.RightArm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.LeftArm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.RightLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.LeftLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Skull.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

