/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;

public class ModelEternalArcher<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("eternal_archer");
    public final ModelPart head;
    public final ModelPart shoulder6;
    public final ModelPart rightleg;
    public final ModelPart leftleg;
    public final ModelPart body;
    public final ModelPart shoulder1;
    public final ModelPart shoulder4;
    public final ModelPart shoulder3;
    public final ModelPart shoulder2;
    public final ModelPart shoulder5;
    public final ModelPart armRight1;
    public final ModelPart armRight2;
    public final ModelPart armRight3;
    public final ModelPart armLeft1;
    public final ModelPart armLeft2;
    public final ModelPart armLeft3;

    public ModelEternalArcher(ModelPart root) {
        this.head = root.getChild("head");
        this.shoulder6 = root.getChild("shoulder6");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.body = root.getChild("body");
        this.shoulder1 = root.getChild("shoulder1");
        this.shoulder4 = root.getChild("shoulder4");
        this.shoulder3 = root.getChild("shoulder3");
        this.shoulder2 = root.getChild("shoulder2");
        this.shoulder5 = root.getChild("shoulder5");
        this.armLeft1 = root.getChild("armLeft1");
        this.armLeft2 = root.getChild("armLeft2");
        this.armLeft3 = root.getChild("armLeft3");
        this.armRight1 = root.getChild("armRight1");
        this.armRight2 = root.getChild("armRight2");
        this.armRight3 = root.getChild("armRight3");
    }

    public ModelEternalArcher(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.shoulder6 = root.getChild("shoulder6");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.body = root.getChild("body");
        this.shoulder1 = root.getChild("shoulder1");
        this.shoulder4 = root.getChild("shoulder4");
        this.shoulder3 = root.getChild("shoulder3");
        this.shoulder2 = root.getChild("shoulder2");
        this.shoulder5 = root.getChild("shoulder5");
        this.armLeft1 = root.getChild("armLeft1");
        this.armLeft2 = root.getChild("armLeft2");
        this.armLeft3 = root.getChild("armLeft3");
        this.armRight1 = root.getChild("armRight1");
        this.armRight2 = root.getChild("armRight2");
        this.armRight3 = root.getChild("armRight3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("shoulder6", CubeListBuilder.create().texOffs(41, 1).mirror().addBox(-4.0f, 0.0f, -2.0f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)18.0f, (float)-6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(46, 16).mirror().addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("shoulder1", CubeListBuilder.create().texOffs(41, 1).mirror().addBox(-4.0f, 0.0f, -2.0f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-20.0f, (float)-6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("shoulder4", CubeListBuilder.create().texOffs(19, 24).mirror().addBox(-4.0f, 0.0f, -2.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)8.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("shoulder3", CubeListBuilder.create().texOffs(19, 24).mirror().addBox(-4.0f, 0.0f, -2.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-6.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("shoulder2", CubeListBuilder.create().texOffs(17, 16).mirror().addBox(-4.0f, 0.0f, -2.0f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-13.0f, (float)-3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("shoulder5", CubeListBuilder.create().texOffs(17, 16).mirror().addBox(-4.0f, 0.0f, -2.0f, 10.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)11.0f, (float)-3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armLeft1", CubeListBuilder.create().texOffs(110, 16).mirror().addBox(-10.0f, -21.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armLeft2", CubeListBuilder.create().texOffs(71, 16).addBox(-17.0f, -24.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armLeft3", CubeListBuilder.create().texOffs(91, 16).addBox(-24.0f, -27.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armRight1", CubeListBuilder.create().texOffs(110, 16).addBox(6.0f, -21.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armRight2", CubeListBuilder.create().texOffs(71, 16).addBox(13.0f, -24.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("armRight3", CubeListBuilder.create().texOffs(91, 16).addBox(20.0f, -27.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rightleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leftleg.xRot = (float)(Math.cos(limbSwing * 0.6662f + (float)Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.armRight1.xRot = 0.0f;
        this.armRight2.xRot = 0.0f;
        this.armRight3.xRot = 0.0f;
        this.armLeft1.xRot = 0.0f;
        this.armLeft2.xRot = 0.0f;
        this.armLeft3.xRot = 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shoulder6.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shoulder1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shoulder4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shoulder3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shoulder2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.shoulder5.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armLeft1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armLeft2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armLeft3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armRight1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armRight2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.armRight3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

