/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityKarot;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelKarot
extends EntityModel<EntityKarot> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("karot");
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart Leg1;
    private final ModelPart Leg2;
    private final ModelPart Leg3;
    private final ModelPart Leg4;
    private final ModelPart Ear1;
    private final ModelPart Ear2;
    private final ModelPart Tail;
    private final ModelPart Shape1;
    private final ModelPart Shape2;
    private final ModelPart Shape3;
    private final ModelPart Shape4;

    public ModelKarot(ModelPart root) {
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.Leg1 = root.getChild("Leg1");
        this.Leg2 = root.getChild("Leg2");
        this.Leg3 = root.getChild("Leg3");
        this.Leg4 = root.getChild("Leg4");
        this.Ear1 = root.getChild("Ear1");
        this.Ear2 = root.getChild("Ear2");
        this.Tail = root.getChild("Tail");
        this.Shape1 = root.getChild("Shape1");
        this.Shape2 = root.getChild("Shape2");
        this.Shape3 = root.getChild("Shape3");
        this.Shape4 = root.getChild("Shape4");
    }

    public ModelKarot(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.Leg1 = root.getChild("Leg1");
        this.Leg2 = root.getChild("Leg2");
        this.Leg3 = root.getChild("Leg3");
        this.Leg4 = root.getChild("Leg4");
        this.Ear1 = root.getChild("Ear1");
        this.Ear2 = root.getChild("Ear2");
        this.Tail = root.getChild("Tail");
        this.Shape1 = root.getChild("Shape1");
        this.Shape2 = root.getChild("Shape2");
        this.Shape3 = root.getChild("Shape3");
        this.Shape4 = root.getChild("Shape4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(16, 10).mirror().addBox(-5.0f, -2.5f, -6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(16, 10).mirror().addBox(3.0f, -2.5f, -6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)-3.0f));
        Body.addOrReplaceChild("Body_r1", CubeListBuilder.create().texOffs(18, 14).mirror().addBox(-4.0f, -4.0f, -13.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)10.0f, (float)3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Leg1", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.5f, (float)16.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("Leg2", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.5f, (float)16.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("Leg3", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.5f, (float)16.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("Leg4", CubeListBuilder.create().texOffs(0, 18).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.5f, (float)16.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("Ear1", CubeListBuilder.create().texOffs(16, 14).mirror().addBox(-3.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        partdefinition.addOrReplaceChild("Ear2", CubeListBuilder.create().texOffs(16, 14).mirror().addBox(1.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        partdefinition.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(6, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)13.0f, (float)4.0f));
        partdefinition.addOrReplaceChild("Shape1", CubeListBuilder.create().texOffs(50, 18).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.0f, (float)9.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Shape2", CubeListBuilder.create().texOffs(50, 18).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)9.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("Shape3", CubeListBuilder.create().texOffs(50, 18).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.0f, (float)9.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("Shape4", CubeListBuilder.create().texOffs(50, 18).mirror().addBox(0.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)9.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityKarot entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.Leg1.xRot = (float)(Math.cos((double)limbSwing * 0.6662) * 1.4 * (double)limbSwingAmount);
        this.Leg2.xRot = (float)(Math.cos((double)limbSwing * 0.6662 + Math.PI) * 1.4 * (double)limbSwingAmount);
        this.Leg3.xRot = (float)(Math.cos((double)limbSwing * 0.6662 + Math.PI) * 1.4 * (double)limbSwingAmount);
        this.Leg4.xRot = (float)(Math.cos((double)limbSwing * 0.6662) * 1.4 * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Ear1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Ear2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Shape1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Shape2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Shape3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Shape4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

