/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityKitra;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelKitra
extends EntityModel<EntityKitra> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("kitra");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart rightFin;
    public final ModelPart leftFin;
    public final ModelPart hip;
    public final ModelPart tailBase;

    public ModelKitra(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.rightFin = this.body.getChild("right_fin");
        this.leftFin = this.body.getChild("left_fin");
        this.hip = this.body.getChild("hip");
        this.tailBase = this.hip.getChild("tail_base");
    }

    public ModelKitra(ModelPart root) {
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.rightFin = this.body.getChild("right_fin");
        this.leftFin = this.body.getChild("left_fin");
        this.hip = this.body.getChild("hip");
        this.tailBase = this.hip.getChild("tail_base");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 72).addBox(-21.0f, -10.0f, -1.0f, 42.0f, 23.0f, 42.0f, cubeDef).texOffs(0, 189).addBox(-2.0f, -15.0f, -1.0f, 4.0f, 8.0f, 41.0f, cubeDef), PartPose.offset((float)0.0f, (float)2.0f, (float)-17.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)-2.0f));
        head.addOrReplaceChild("head_rot", CubeListBuilder.create().texOffs(0, 0).addBox(-19.0f, -7.0f, -47.0f, 38.0f, 24.0f, 48.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-1.0f, (float)0.1308997f, (float)0.0f, (float)0.0f));
        PartDefinition rightFin = body.addOrReplaceChild("right_fin", CubeListBuilder.create(), PartPose.offset((float)-24.0f, (float)8.0f, (float)17.0f));
        rightFin.addOrReplaceChild("right_fin_rot", CubeListBuilder.create().texOffs(0, 137).addBox(-6.0f, -5.0f, 1.0f, 8.0f, 34.0f, 18.0f, cubeDef), PartPose.offsetAndRotation((float)5.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.17453294f));
        PartDefinition leftFin = body.addOrReplaceChild("left_fin", CubeListBuilder.create(), PartPose.offset((float)24.0f, (float)8.0f, (float)17.0f));
        leftFin.addOrReplaceChild("left_fin_rot", CubeListBuilder.create().texOffs(52, 137).addBox(-1.0f, -5.0f, 1.0f, 8.0f, 34.0f, 18.0f, cubeDef), PartPose.offsetAndRotation((float)-5.0f, (float)4.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)-0.17453294f));
        PartDefinition hip = body.addOrReplaceChild("hip", CubeListBuilder.create().texOffs(126, 72).addBox(-16.0f, 1.0f, -1.0f, 32.0f, 19.0f, 16.0f, cubeDef).texOffs(152, 189).addBox(-2.0f, -5.0f, 1.0f, 4.0f, 8.0f, 15.0f, cubeDef), PartPose.offset((float)0.0f, (float)-10.0f, (float)39.0f));
        PartDefinition tailBase = hip.addOrReplaceChild("tail_base", CubeListBuilder.create().texOffs(104, 137).addBox(-13.0f, -2.0f, -1.5f, 26.0f, 18.0f, 11.0f, cubeDef).texOffs(172, 0).addBox(-2.0f, -9.0f, -0.5f, 4.0f, 8.0f, 9.0f, cubeDef), PartPose.offset((float)0.0f, (float)4.0f, (float)16.5f));
        PartDefinition tailSegment1 = tailBase.addOrReplaceChild("tail_segment_1", CubeListBuilder.create().texOffs(172, 17).addBox(-2.0f, -8.5f, -1.25f, 4.0f, 8.0f, 10.0f, cubeDef).texOffs(103, 166).addBox(-11.0f, -1.5f, -1.25f, 22.0f, 12.0f, 11.0f, cubeDef), PartPose.offset((float)0.0f, (float)-0.5f, (float)10.75f));
        PartDefinition tailSegment2 = tailSegment1.addOrReplaceChild("tail_segment_2", CubeListBuilder.create().texOffs(103, 166).addBox(-11.0f, -1.5f, -0.5f, 22.0f, 12.0f, 11.0f, cubeDef).texOffs(172, 35).addBox(-2.0f, -8.5f, -0.5f, 4.0f, 8.0f, 11.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)10.25f));
        PartDefinition tailSegment3 = tailSegment2.addOrReplaceChild("tail_segment_3", CubeListBuilder.create().texOffs(103, 166).addBox(-11.0f, -1.5f, 0.0f, 22.0f, 12.0f, 11.0f, cubeDef).texOffs(172, 35).addBox(-2.0f, -8.5f, 1.0f, 4.0f, 8.0f, 11.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)10.5f));
        tailSegment3.addOrReplaceChild("tail_tip", CubeListBuilder.create().texOffs(90, 189).addBox(0.0f, -4.5f, 0.5f, 0.0f, 13.0f, 31.0f, cubeDef), PartPose.offset((float)0.0f, (float)-6.0f, (float)11.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(EntityKitra entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = Mth.cos((float)(limbSwing * 0.2f)) * limbSwingAmount / 8.0f;
        if (!entity.onGround() || entity.isInWater()) {
            this.body.xRot = headPitch * ((float)Math.PI / 180) / 4.0f;
            this.body.yRot = netHeadYaw * ((float)Math.PI / 180) / 4.0f;
        } else {
            this.body.yRot = 0.0f;
            this.body.xRot = 0.0f;
        }
        this.rightFin.zRot = -Mth.sin((float)(10.0f * ageInTicks / 57.295776f)) * 0.3f;
        this.leftFin.zRot = -this.rightFin.zRot;
        this.hip.xRot = this.tailBase.xRot = -this.head.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

