/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityReyvor;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelReyvor<E extends EntityReyvor>
extends EntityModel<EntityReyvor> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("reyvor");
    private final ModelPart body;
    public final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart head;

    public ModelReyvor(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.rightarm = root.getChild("rightarm");
        this.leftarm = root.getChild("leftarm");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).mirror().addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(40, 4).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 18.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(40, 1).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 18.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubedef).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-9.4667f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(2.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(6.5333f, -16.0f, -3.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(-14.4667f, -16.0f, -3.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(-3.4667f, -16.0f, -3.0f, 8.0f, 8.0f, 8.0f, cubedef).mirror(false), PartPose.offset((float)-0.5333f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityReyvor entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightarm.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * 2.0 * (double)limbSwingAmount * 0.5);
        this.leftarm.xRot = (float)(Math.cos(limbSwing * 0.6662f) * 2.0 * (double)limbSwingAmount * 0.5);
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        this.rightleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leftleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

