/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntitySunstorm;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class ModelSunstorm
extends HumanoidModel<EntitySunstorm> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("sunstorm");
    public final ModelPart rightSoul;
    public final ModelPart middleSoul;
    public final ModelPart leftSoul;
    public final ModelPart hip;

    public ModelSunstorm(ModelPart root) {
        super(root);
        this.rightSoul = this.body.getChild("right_soul");
        this.middleSoul = this.body.getChild("middle_soul");
        this.leftSoul = this.body.getChild("left_soul");
        this.hip = root.getChild("hip");
    }

    public static LayerDefinition createBodyLayer() {
        CubeDeformation cubeDef = CubeDeformation.NONE;
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDef, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(34, 106).addBox(-6.0f, -8.0f, -4.0f, 12.0f, 15.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)-21.0f, (float)-5.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-12.0f, -23.0f, -6.0f, 24.0f, 22.0f, 18.0f, cubeDef), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        body.addOrReplaceChild("middle_soul", CubeListBuilder.create().texOffs(61, 40).addBox(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-28.0f, (float)-8.0f, (float)-0.43633235f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_soul", CubeListBuilder.create().texOffs(45, 40).addBox(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)-10.0f, (float)-24.0f, (float)-8.0f, (float)-0.34906587f, (float)0.0f, (float)-0.5235988f));
        body.addOrReplaceChild("left_soul", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -8.0f, -1.0f, 6.0f, 9.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)10.0f, (float)-24.0f, (float)-8.0f, (float)-0.34906587f, (float)0.0f, (float)0.5235988f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(104, 103).addBox(-9.0f, 1.0f, -4.0f, 8.0f, 10.0f, 8.0f, cubeDef).texOffs(30, 86).addBox(-12.0f, -7.0f, -6.0f, 12.0f, 8.0f, 12.0f, cubeDef), PartPose.offset((float)-12.0f, (float)-23.0f, (float)2.0f));
        rightArm.addOrReplaceChild("right_cannon", CubeListBuilder.create().texOffs(0, 64).addBox(-5.0f, 0.0f, -4.0f, 10.0f, 22.0f, 11.0f, cubeDef), PartPose.offset((float)-5.0f, (float)10.0f, (float)-1.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(84, 0).addBox(0.0f, -7.0f, -6.0f, 12.0f, 8.0f, 12.0f, cubeDef).texOffs(89, 57).addBox(1.0f, 1.0f, -4.0f, 8.0f, 10.0f, 8.0f, cubeDef), PartPose.offset((float)12.0f, (float)-23.0f, (float)2.0f));
        leftArm.addOrReplaceChild("left_cannon", CubeListBuilder.create().texOffs(47, 53).addBox(-5.0f, 0.0f, -4.0f, 10.0f, 22.0f, 11.0f, cubeDef), PartPose.offset((float)5.0f, (float)10.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("hip", CubeListBuilder.create().texOffs(0, 40).addBox(-8.0f, -2.0f, -4.0f, 16.0f, 11.0f, 13.0f, cubeDef), PartPose.offset((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 98).addBox(-6.0f, 0.0f, -3.0f, 9.0f, 12.0f, 8.0f, cubeDef), PartPose.offset((float)-5.0f, (float)-4.0f, (float)1.0f));
        rightLeg.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(79, 76).addBox(-5.0f, 0.0f, -4.0f, 11.0f, 17.0f, 10.0f, cubeDef), PartPose.offset((float)-2.0f, (float)11.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(70, 103).addBox(-3.0f, 0.0f, -3.0f, 9.0f, 12.0f, 8.0f, cubeDef), PartPose.offset((float)5.0f, (float)-4.0f, (float)1.0f));
        leftLeg.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(78, 30).addBox(-6.0f, 0.0f, -4.0f, 11.0f, 17.0f, 10.0f, cubeDef), PartPose.offset((float)2.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void prepareMobModel(EntitySunstorm entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        super.prepareMobModel((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
        this.rightSoul.visible = entity.getHealth() > 2.0f * entity.getMaxHealth() / 3.0f;
        this.leftSoul.visible = entity.getHealth() > entity.getMaxHealth() / 2.0f;
        this.middleSoul.visible = entity.getHealth() > entity.getMaxHealth() / 3.0f;
    }

    public void setupAnim(EntitySunstorm entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.yRot = 0.0f;
        this.head.xRot = 0.0f;
        this.hat.y = -21.0f;
        this.head.y = -21.0f;
        this.body.y = -8.0f;
        this.rightArm.x = -12.0f;
        this.leftArm.x = -this.rightArm.x;
        this.leftArm.y = -23.0f;
        this.rightArm.y = -23.0f;
        this.leftArm.z = 2.0f;
        this.rightArm.z = 2.0f;
        this.leftLeg.y = -4.0f;
        this.rightLeg.y = -4.0f;
        this.leftLeg.z = 1.0f;
        this.rightLeg.z = 1.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.hip.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

