/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.boss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.boss.EntityWreck;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelWreckRanged
extends EntityModel<EntityWreck> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("wreck_ranged");
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart cannon;
    private final ModelPart rightarm;

    public ModelWreckRanged(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.leftarm = root.getChild("leftarm");
        this.cannon = root.getChild("cannon");
        this.rightarm = root.getChild("rightarm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-3.0f, -3.0f, 0.0f, 2.0f, 8.0f, 4.0f, cubedef).mirror(false).texOffs(0, 18).mirror().addBox(-4.0f, -4.0f, -1.0f, 4.0f, 2.0f, 6.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        rightleg.addOrReplaceChild("rightleg2_r1", CubeListBuilder.create().texOffs(4, 21).mirror().addBox(-2.0f, -7.0f, -1.5f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false).texOffs(4, 21).mirror().addBox(-7.0f, -7.0f, -1.5f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)12.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        rightleg.addOrReplaceChild("rightleg8_r1", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-8.0f, -7.3f, 2.1f, 2.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(0, 24).mirror().addBox(-2.0f, -7.3f, 2.1f, 2.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(0, 19).mirror().addBox(-6.0f, -7.3f, 2.1f, 4.0f, 8.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)12.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 17).mirror().addBox(1.0f, -3.0f, 0.0f, 2.0f, 8.0f, 4.0f, cubedef).mirror(false).texOffs(0, 19).mirror().addBox(0.0f, -4.0f, -1.0f, 4.0f, 2.0f, 6.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)12.0f, (float)0.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        leftleg.addOrReplaceChild("leftleg5_r1", CubeListBuilder.create().texOffs(4, 21).mirror().addBox(6.0f, -7.0f, -1.5f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false).texOffs(4, 21).mirror().addBox(1.0f, -7.0f, -1.5f, 1.0f, 8.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        leftleg.addOrReplaceChild("leftleg3_r1", CubeListBuilder.create().texOffs(0, 25).mirror().addBox(6.0f, -7.3f, 2.1f, 2.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(0, 25).mirror().addBox(0.0f, -7.3f, 2.1f, 2.0f, 2.0f, 2.0f, cubedef).mirror(false).texOffs(0, 20).mirror().addBox(2.0f, -7.3f, 2.1f, 4.0f, 8.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(19, 16).mirror().addBox(-4.0f, 0.0f, -2.0f, 6.0f, 12.0f, 2.0f, cubedef).mirror(false).texOffs(19, 20).mirror().addBox(-5.0f, 9.0f, -3.0f, 8.0f, 2.0f, 4.0f, cubedef).mirror(false).texOffs(19, 20).mirror().addBox(-5.0f, 5.0f, -3.0f, 8.0f, 2.0f, 4.0f, cubedef).mirror(false).texOffs(19, 20).mirror().addBox(-5.0f, 1.0f, -3.0f, 8.0f, 2.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)-1.0f, (float)-2.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("part3_r1", CubeListBuilder.create().texOffs(42, 20).mirror().addBox(-11.8f, -23.9f, -11.5f, 4.0f, 10.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)25.0f, (float)2.0f, (float)-0.3185f, (float)0.3035f, (float)0.7363f));
        body.addOrReplaceChild("part4_r1", CubeListBuilder.create().texOffs(42, 20).mirror().addBox(8.3f, -23.2f, -11.5f, 4.0f, 10.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)25.0f, (float)2.0f, (float)-0.3185f, (float)-0.3035f, (float)-0.7363f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(5, 0).mirror().addBox(1.0f, -7.0f, -4.0f, 3.0f, 8.0f, 8.0f, cubedef).mirror(false).texOffs(16, 9).mirror().addBox(-1.0f, -4.0f, -2.0f, 2.0f, 3.0f, 3.0f, cubedef).mirror(false).texOffs(0, 0).mirror().addBox(-4.0f, -7.0f, -4.0f, 3.0f, 8.0f, 8.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-3.0f, (float)0.1396f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(4.0f, 3.0f, -1.0f, 2.0f, 7.0f, 2.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(3.0f, 8.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(15, 18).mirror().addBox(2.0f, 11.0f, -3.0f, 6.0f, 2.0f, 6.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)5.0f, (float)2.0f, (float)0.0f, (float)-1.1345f, (float)-0.5236f, (float)0.0f));
        leftarm.addOrReplaceChild("part35_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-3.0f, 3.2082f, -1.0624f, 4.0f, 7.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)0.0f, (float)-8.0f, (float)1.0314f, (float)0.1848f, (float)0.2978f));
        PartDefinition cannon = partdefinition.addOrReplaceChild("cannon", CubeListBuilder.create().texOffs(19, 0).mirror().addBox(2.0f, -8.0f, 4.0f, 16.0f, 1.0f, 1.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(5.0f, -7.0f, 4.0f, 2.0f, 1.0f, 1.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(2.0f, -6.0f, 4.0f, 16.0f, 1.0f, 1.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(13.0f, -7.0f, 4.0f, 2.0f, 1.0f, 1.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(13.0f, -5.0f, 4.0f, 2.0f, 3.0f, 1.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(5.0f, -5.0f, 4.0f, 2.0f, 3.0f, 1.0f, cubedef).mirror(false).texOffs(19, 0).mirror().addBox(4.0f, -2.0f, 4.0f, 12.0f, 2.0f, 1.0f, cubedef).mirror(false).texOffs(38, 5).mirror().addBox(0.0f, -2.0f, -1.0f, 4.0f, 2.0f, 9.0f, cubedef).mirror(false).texOffs(38, 5).mirror().addBox(8.0f, -2.0f, -1.0f, 4.0f, 2.0f, 9.0f, cubedef).mirror(false).texOffs(38, 5).mirror().addBox(16.0f, -2.0f, -1.0f, 4.0f, 2.0f, 9.0f, cubedef).mirror(false).texOffs(58, 18).mirror().addBox(16.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, cubedef).mirror(false).texOffs(58, 18).mirror().addBox(19.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, cubedef).mirror(false).texOffs(58, 18).mirror().addBox(11.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, cubedef).mirror(false).texOffs(58, 18).mirror().addBox(8.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, cubedef).mirror(false).texOffs(58, 18).mirror().addBox(3.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, cubedef).mirror(false).texOffs(58, 18).mirror().addBox(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f, cubedef).mirror(false), PartPose.offset((float)-10.0f, (float)12.0f, (float)-11.0f));
        cannon.addOrReplaceChild("Shape17_r1", CubeListBuilder.create().texOffs(1, 25).mirror().addBox(-0.3f, 2.0f, -2.0f, 7.0f, 3.0f, 3.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)-9.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        cannon.addOrReplaceChild("Shape12_r1", CubeListBuilder.create().texOffs(38, 5).mirror().addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 9.0f, cubedef).mirror(false).texOffs(38, 5).mirror().addBox(15.0f, 0.0f, 0.0f, 2.0f, 2.0f, 9.0f, cubedef).mirror(false).texOffs(38, 5).mirror().addBox(7.0f, 0.0f, 0.0f, 2.0f, 2.0f, 9.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)2.0f, (float)-1.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        cannon.addOrReplaceChild("Shape15_r1", CubeListBuilder.create().texOffs(27, 11).mirror().addBox(-1.0f, 0.0f, 0.0f, 2.0f, 1.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-2.0f, (float)0.0f, (float)0.6196f, (float)0.0f, (float)0.0f));
        cannon.addOrReplaceChild("Shape23_r1", CubeListBuilder.create().texOffs(27, 11).mirror().addBox(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 4.0f, cubedef).mirror(false).texOffs(27, 11).mirror().addBox(-18.0f, 0.0f, 0.0f, 2.0f, 1.0f, 4.0f, cubedef).mirror(false).texOffs(27, 11).mirror().addBox(-10.0f, 0.0f, 0.0f, 2.0f, 1.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)19.0f, (float)-2.0f, (float)3.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        cannon.addOrReplaceChild("Shape22_r1", CubeListBuilder.create().texOffs(27, 11).mirror().addBox(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 4.0f, cubedef).mirror(false).texOffs(27, 11).mirror().addBox(-10.0f, 0.0f, 0.0f, 2.0f, 1.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)19.0f, (float)-2.0f, (float)0.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        cannon.addOrReplaceChild("Shape3_r1", CubeListBuilder.create().texOffs(1, 25).mirror().addBox(-5.0f, 0.0f, -1.0f, 7.0f, 3.0f, 3.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)22.0f, (float)-7.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.2531f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-12.0f, (float)1.0f, (float)0.0f, (float)-1.0883f, (float)0.0813f, (float)0.0584f));
        rightarm.addOrReplaceChild("part12_r1", CubeListBuilder.create().texOffs(15, 18).mirror().addBox(-2.6f, 7.1f, -3.0f, 6.0f, 2.0f, 6.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(-1.6f, 4.1f, -2.0f, 4.0f, 4.0f, 4.0f, cubedef).mirror(false).texOffs(40, 16).mirror().addBox(-0.6f, -0.9f, -1.0f, 2.0f, 7.0f, 2.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-0.7942f, (float)1.9216f, (float)1.9018f, (float)0.0f, (float)0.0f, (float)0.1745f));
        rightarm.addOrReplaceChild("part36_r1", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(0.0f, 4.2082f, -1.0624f, 4.0f, 7.0f, 4.0f, cubedef).mirror(false), PartPose.offsetAndRotation((float)-1.7942f, (float)-4.0784f, (float)-6.0982f, (float)1.0105f, (float)0.0934f, (float)0.1476f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityWreck entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leftleg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.rightleg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.cannon.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

