/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityAlicanto;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelAlicanto
extends EntityModel<EntityAlicanto> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("alicanto");
    private final ModelPart Head;
    private final ModelPart Jaw;
    private final ModelPart Body;
    private final ModelPart RightWing;
    private final ModelPart LeftWing;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public ModelAlicanto(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Jaw = this.Head.getChild("Jaw");
        this.Body = root.getChild("Body");
        this.RightWing = root.getChild("RightWing");
        this.LeftWing = root.getChild("LeftWing");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(17, 48).addBox(3.0f, 0.0f, -11.0f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(46, 20).addBox(-5.0f, 0.0f, -11.0f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(27, 21).addBox(-2.0f, -6.0f, -14.0f, 4.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(3.0f, -7.0f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(-5.0f, -7.0f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 41).addBox(-3.0f, -5.0f, -6.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(28, 48).addBox(-2.0f, 0.5f, -5.0f, 4.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.5f, (float)-7.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(40, 12).addBox(-2.0f, 1.0f, 10.0f, 4.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)-4.0f));
        Body.addOrReplaceChild("tuff_r1", CubeListBuilder.create().texOffs(50, 39).addBox(-4.0f, -7.0f, 1.0f, 8.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -7.0f, -9.0f, 8.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)7.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition RightWing = partdefinition.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(0, 20).addBox(-9.0f, -1.0f, -4.0f, 9.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        RightWing.addOrReplaceChild("RightWingTip", CubeListBuilder.create().texOffs(0, 32).addBox(-9.5f, -1.0f, -3.5f, 9.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.5f, (float)0.0f, (float)-0.5f));
        PartDefinition LeftWing = partdefinition.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(28, 0).addBox(0.0f, -1.0f, -4.0f, 9.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        LeftWing.addOrReplaceChild("LeftWingTip", CubeListBuilder.create().texOffs(25, 39).addBox(0.5f, -1.0f, -3.5f, 9.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.5f, (float)0.0f, (float)-0.5f));
        partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(48, 48).addBox(-2.0f, 0.0f, -3.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)17.0f, (float)2.0f));
        partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)17.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityAlicanto entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        if (!entity.onGround()) {
            this.RightWing.y = 10.0f;
            this.RightWing.z = 0.0f;
            this.LeftWing.y = this.RightWing.y;
            this.LeftWing.z = this.RightWing.z;
            this.RightWing.yRot = 0.0f;
            this.LeftWing.yRot = 0.0f;
            this.RightWing.zRot = Mth.cos((float)(ageInTicks * 25.0f * ((float)Math.PI / 180))) * (float)Math.PI * 0.25f;
            this.LeftWing.zRot = -this.RightWing.zRot;
            this.RightLeg.xRot = 0.3927f;
            this.LeftLeg.xRot = 0.3927f;
        } else {
            this.RightWing.y = 12.0f;
            this.RightWing.z = -3.0f;
            this.LeftWing.y = this.RightWing.y;
            this.LeftWing.z = this.RightWing.z;
            this.RightWing.yRot = 1.5708f;
            this.LeftWing.yRot = -1.5708f;
            this.RightWing.zRot = -this.RightWing.yRot;
            this.LeftWing.zRot = -this.LeftWing.yRot;
            this.RightLeg.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
            this.LeftLeg.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        }
    }

    public void prepareMobModel(EntityAlicanto p_103621_, float p_103622_, float p_103623_, float p_103624_) {
        super.prepareMobModel((Entity)p_103621_, p_103622_, p_103623_, p_103624_);
        int l = p_103621_.getAttackTick();
        this.Jaw.xRot = l > 0 ? (l > 5 ? Mth.sin((float)(((float)(-4 + l) - p_103624_) / 4.0f)) * (float)Math.PI * 0.4f : 0.15707964f * Mth.sin((float)((float)Math.PI * ((float)l - p_103624_) / 10.0f))) : 0.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

