/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityCauldronFish;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelCauldronFish
extends EntityModel<EntityCauldronFish> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("cauldron_fish");
    final ModelPart body;
    final ModelPart rightFin;
    final ModelPart leftFin;

    public ModelCauldronFish(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("Body");
        this.leftFin = root.getChild("LeftFin");
        this.rightFin = root.getChild("RightFin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation zero = new CubeDeformation(0.0f);
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -13.0f, -4.5f, 9.0f, 6.0f, 9.0f, zero).texOffs(0, 15).addBox(-3.5f, -7.0f, -3.5f, 7.0f, 2.0f, 7.0f, zero), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        Body.addOrReplaceChild("Tendrils", CubeListBuilder.create().texOffs(21, 15).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 5.0f, 0.0f, zero).texOffs(0, 17).addBox(0.0f, 0.0f, -3.5f, 0.0f, 5.0f, 7.0f, zero), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("LeftFin", CubeListBuilder.create().texOffs(0, 4).addBox(-0.5f, -2.0f, 0.0f, 3.0f, 4.0f, 0.0f, zero), PartPose.offset((float)4.5f, (float)14.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("RightFin", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -2.0f, 0.0f, 3.0f, 4.0f, 0.0f, zero), PartPose.offset((float)-4.5f, (float)14.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityCauldronFish entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.isInWater()) {
            this.rightFin.xRot = 0.0f;
            this.leftFin.xRot = 0.0f;
            this.body.xRot = 0.0f;
            this.leftFin.yRot = (float)Math.sin(ageInTicks);
            this.rightFin.yRot = -this.leftFin.yRot;
            this.rightFin.zRot = 0.0f;
            this.leftFin.zRot = 0.0f;
            this.rightFin.y = 14.0f;
            this.leftFin.y = 14.0f;
            this.body.z = 0.0f;
        } else {
            this.rightFin.xRot = 1.5707964f;
            this.leftFin.xRot = 1.5707964f;
            this.body.xRot = 1.5707964f;
            this.leftFin.zRot = (float)Math.sin(ageInTicks);
            this.rightFin.zRot = -this.leftFin.zRot;
            this.rightFin.yRot = 0.0f;
            this.leftFin.yRot = 0.0f;
            this.rightFin.y = 24.0f;
            this.leftFin.y = 24.0f;
            this.body.z = 10.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftFin.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightFin.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

