/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityDolossal;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelDolossal
extends AgeableListModel<EntityDolossal> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("dolossal");
    final ModelPart body;
    final ModelPart neck;
    final ModelPart head;
    final ModelPart rightLeg;
    final ModelPart leftLeg;
    final ModelPart leftWing;
    final ModelPart rightWing;
    final ModelPart[] saddleParts;
    final ModelPart[] ridingParts;

    public ModelDolossal(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("Body");
        this.neck = root.getChild("Neck");
        this.head = this.neck.getChild("Head");
        this.rightLeg = this.body.getChild("RightLeg");
        this.leftLeg = this.body.getChild("LeftLeg");
        this.rightWing = this.body.getChild("RightWing");
        this.leftWing = this.body.getChild("LeftWing");
        this.saddleParts = new ModelPart[]{this.body.getChild("saddle"), this.head.getChild("left_saddle_mouth"), this.head.getChild("right_saddle_mouth"), this.head.getChild("head_saddle"), this.head.getChild("mouth_saddle_wrap")};
        this.ridingParts = new ModelPart[]{this.neck.getChild("left_saddle_line"), this.neck.getChild("right_saddle_line")};
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubedef = new CubeDeformation(0.0f);
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.3028f, -7.0f, -4.0304f, 16.0f, 14.0f, 21.0f, cubedef), PartPose.offset((float)0.0f, (float)5.0f, (float)-5.0f));
        Body.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 57).addBox(-6.0f, -3.0f, -4.0f, 8.0f, 7.0f, 8.0f, cubedef).texOffs(59, 75).addBox(-4.0f, 1.0f, -2.0f, 5.0f, 13.0f, 5.0f, cubedef), PartPose.offset((float)-3.3028f, (float)5.0f, (float)8.9696f));
        Body.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(32, 61).addBox(-2.0f, -3.0f, -4.0f, 8.0f, 7.0f, 8.0f, cubedef).texOffs(0, 72).addBox(-1.0f, 1.0f, -2.0f, 5.0f, 13.0f, 5.0f, cubedef), PartPose.offset((float)4.6972f, (float)5.0f, (float)8.9696f));
        Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(68, 26).addBox(-3.0f, -1.0f, 0.5f, 6.0f, 2.0f, 9.0f, cubedef), PartPose.offsetAndRotation((float)0.6972f, (float)-6.0f, (float)16.4696f, (float)-0.9163f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(20, 72).addBox(-3.0f, -1.5f, -1.0f, 2.0f, 7.0f, 8.0f, cubedef), PartPose.offset((float)-6.3028f, (float)-5.5f, (float)-1.0304f));
        Body.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(76, 37).addBox(1.0f, -1.5f, -1.0f, 2.0f, 7.0f, 8.0f, cubedef), PartPose.offsetAndRotation((float)7.6972f, (float)-5.5f, (float)-1.0304f, (float)0.0f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("saddle", CubeListBuilder.create().texOffs(48, 101).addBox(-5.0f, -8.0f, -9.0f, 10.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        PartDefinition Neck = partdefinition.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(40, 35).addBox(-5.0f, -17.0f, -8.0f, 10.0f, 18.0f, 8.0f, cubedef), PartPose.offset((float)0.0f, (float)6.0f, (float)-5.0f));
        Neck.addOrReplaceChild("left_saddle_line", CubeListBuilder.create().texOffs(54, 103).addBox(3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.rotation((float)-0.5235988f, (float)0.0f, (float)0.0f));
        Neck.addOrReplaceChild("right_saddle_line", CubeListBuilder.create().texOffs(54, 103).addBox(-3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.rotation((float)-0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 35).addBox(-4.0f, -9.0f, -11.0f, 8.0f, 10.0f, 12.0f, cubedef).texOffs(0, 0).addBox(0.0f, -15.0f, 0.0f, 0.0f, 8.0f, 10.0f, cubedef), PartPose.offset((float)0.0f, (float)-13.0f, (float)-3.0f));
        Head.addOrReplaceChild("left_saddle_mouth", CubeListBuilder.create().texOffs(51, 106).addBox(2.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubedef), PartPose.ZERO);
        Head.addOrReplaceChild("right_saddle_mouth", CubeListBuilder.create().texOffs(51, 106).addBox(-3.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, cubedef), PartPose.ZERO);
        Head.addOrReplaceChild("head_saddle", CubeListBuilder.create().texOffs(23, 102).addBox(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.22f)), PartPose.ZERO);
        Head.addOrReplaceChild("mouth_saddle_wrap", CubeListBuilder.create().texOffs(41, 101).addBox(-2.0f, -11.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.ZERO);
        Head.addOrReplaceChild("UpperJaw", CubeListBuilder.create().texOffs(0, 97).addBox(-2.0f, -3.75f, -13.0f, 4.0f, 10.0f, 2.0f, cubedef).texOffs(53, 0).addBox(-3.0f, -3.75f, -11.0f, 6.0f, 5.0f, 10.0f, cubedef), PartPose.offset((float)0.0f, (float)-5.25f, (float)-10.0f));
        Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(64, 61).addBox(-3.0f, -1.0f, -11.0f, 6.0f, 4.0f, 10.0f, cubedef), PartPose.offset((float)0.0f, (float)-3.0f, (float)-10.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityDolossal entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean saddled = entity.isSaddled();
        boolean vehicle = entity.isVehicle();
        for (ModelPart modelpart : this.saddleParts) {
            modelpart.visible = saddled;
        }
        for (ModelPart modelpart1 : this.ridingParts) {
            modelpart1.visible = saddled && vehicle;
        }
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.neck.xRot = Mth.sin((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount;
        this.head.xRot = -this.neck.xRot;
        this.rightWing.zRot = Mth.abs((float)(!entity.onGround() ? 1.5707964f + Mth.sin((float)(ageInTicks * 0.2f)) * 0.5f : Mth.cos((float)(limbSwing * 0.5f)) * 0.3f * limbSwingAmount));
        this.leftWing.zRot = -this.rightWing.zRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.neck.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.neck);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }
}

