/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import divinerpg.entities.iceika.groglin.Groglin;
import divinerpg.items.ranged.ItemRangedWeapon;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;

public class ModelGroglin
extends HumanoidModel<Groglin> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("groglin");

    public ModelGroglin(ModelPart part) {
        super(part);
    }

    public static LayerDefinition createBodyLayer() {
        CubeDeformation cubeDef = CubeDeformation.NONE;
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDef, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 34).addBox(4.0f, -9.0f, 0.0f, 1.0f, 5.0f, 5.0f, cubeDef).texOffs(32, 24).addBox(-5.0f, -9.0f, 0.0f, 1.0f, 5.0f, 5.0f, cubeDef).texOffs(0, 0).addBox(-1.0f, -3.0f, -6.0f, 2.0f, 5.0f, 2.0f, cubeDef).texOffs(0, 0).addBox(-4.0f, -7.0f, -4.0f, 8.0f, 7.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(20, 44).addBox(-4.0f, -7.0f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.ZERO);
        body.addOrReplaceChild("spine", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, -5.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDef), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 14).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 11.0f, 4.0f, cubeDef).texOffs(48, 16).addBox(-1.5f, 5.0f, -2.5f, 3.0f, 2.0f, 5.0f, cubeDef), PartPose.offset((float)-5.0f, (float)0.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(48, 0).addBox(-1.5f, 5.0f, -2.5f, 3.0f, 2.0f, 5.0f, cubeDef).texOffs(20, 29).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 11.0f, 4.0f, cubeDef), PartPose.offset((float)5.0f, (float)0.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 42).addBox(-2.0f, 3.0f, -2.5f, 4.0f, 2.0f, 5.0f, cubeDef).texOffs(32, 0).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 8.0f, 4.0f, cubeDef), PartPose.offset((float)-2.5f, (float)0.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 42).addBox(-2.0f, 3.0f, -2.5f, 4.0f, 2.0f, 5.0f, cubeDef).texOffs(0, 30).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 8.0f, 4.0f, cubeDef), PartPose.offset((float)2.5f, (float)0.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(Groglin entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        if ((entity.getMainHandItem().getItem() instanceof BowItem || entity.getMainHandItem().getItem() instanceof ItemRangedWeapon) && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setupAnim(Groglin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftArm.y = 6.0f;
        this.rightArm.y = 6.0f;
        this.leftLeg.y = 16.0f;
        this.rightLeg.y = 16.0f;
        this.hat.y = 4.0f;
        this.head.y = 4.0f;
        this.body.y = 8.0f;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.getArm(arm);
        modelpart.x += f;
        modelpart.translateAndRotate(stack);
        modelpart.x -= f;
    }
}

