/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityMamoth;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelMamoth
extends EntityModel<EntityMamoth> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("mamoth");
    final ModelPart head;
    final ModelPart body;
    final ModelPart frontLeftLeg;
    final ModelPart frontRightLeg;
    final ModelPart backLeftLeg;
    final ModelPart backRightLeg;
    final ModelPart rightEar;
    final ModelPart leftEar;

    public ModelMamoth(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("Head");
        this.rightEar = this.head.getChild("RightEar");
        this.leftEar = this.head.getChild("LeftEar");
        this.body = root.getChild("Body");
        this.frontRightLeg = this.body.getChild("FrontRightLeg");
        this.frontLeftLeg = this.body.getChild("FrontLeftLeg");
        ModelPart hip = this.body.getChild("Hip");
        this.backRightLeg = hip.getChild("BackRightLeg");
        this.backLeftLeg = hip.getChild("BackLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 58).addBox(-4.0f, -3.0f, -10.0f, 8.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)-14.0f));
        PartDefinition LeftEar = Head.addOrReplaceChild("LeftEar", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-2.0f, (float)-4.0f));
        LeftEar.addOrReplaceChild("BottomLeftEar", CubeListBuilder.create().texOffs(82, 69).addBox(-0.5f, 0.0f, 0.0f, 13.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-1.0f, (float)0.0f, (float)-0.0349f, (float)-0.1222f, (float)0.2618f));
        LeftEar.addOrReplaceChild("TopLeftEar", CubeListBuilder.create().texOffs(72, 43).addBox(0.0f, -12.5f, 0.0f, 16.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-1.0f, (float)-0.0438f, (float)-0.1745f, (float)0.0038f));
        PartDefinition RightEar = Head.addOrReplaceChild("RightEar", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)-2.0f, (float)-4.0f));
        RightEar.addOrReplaceChild("BottomRightEar", CubeListBuilder.create().texOffs(80, 19).addBox(-11.5f, 0.0f, 0.0f, 13.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-1.0f, (float)0.0f, (float)-0.0349f, (float)0.1222f, (float)-0.2618f));
        RightEar.addOrReplaceChild("TopRightEar", CubeListBuilder.create().texOffs(81, 56).addBox(-16.0f, -12.5f, 0.0f, 16.0f, 13.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-1.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        Head.addOrReplaceChild("Trunk", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)-9.0f));
        Head.addOrReplaceChild("LeftMandible", CubeListBuilder.create().texOffs(91, 79).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)3.0f, (float)-9.0f, (float)-0.2618f, (float)0.0f, (float)-0.3927f));
        Head.addOrReplaceChild("RightMandible", CubeListBuilder.create().texOffs(89, 29).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)3.0f, (float)-9.0f, (float)-0.2618f, (float)0.0f, (float)0.3927f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)8.0f, (float)-12.0f));
        Body.addOrReplaceChild("chest_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -10.0f, -8.5f, 16.0f, 14.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)6.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(45, 49).addBox(-5.0f, -1.0f, -5.0f, 9.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)3.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        Body.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(53, 20).addBox(-4.0f, 0.0f, -5.0f, 9.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)3.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition Hip = Body.addOrReplaceChild("Hip", CubeListBuilder.create().texOffs(0, 29).addBox(-6.0f, -6.0f, -1.5f, 12.0f, 14.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)9.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        Hip.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(27, 72).addBox(-5.0f, 0.0f, -4.5f, 7.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)7.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        Hip.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(59, 72).addBox(-2.0f, 0.0f, -4.5f, 7.0f, 14.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)7.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        Hip.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(62, 0).addBox(-3.5f, -7.0f, 0.0f, 7.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 78).addBox(-2.5f, -6.0f, 6.0f, 5.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)12.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityMamoth entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.onGround() || entity.isInWater() || !entity.isBaby()) {
            this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
            this.head.xRot = headPitch * ((float)Math.PI / 180);
            this.frontLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.3f * limbSwingAmount;
            this.backLeftLeg.xRot = -Mth.cos((float)(limbSwing * 0.6662f)) * 1.3f * limbSwingAmount;
            this.frontRightLeg.xRot = -Mth.cos((float)(limbSwing * 0.6662f)) * 1.3f * limbSwingAmount;
            this.backRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.3f * limbSwingAmount;
            this.body.zRot = Mth.sin((float)(limbSwing * 0.3331f)) * 0.2f * limbSwingAmount;
            this.body.xRot = 0.0f;
            this.leftEar.xRot = 0.0f;
            this.rightEar.xRot = 0.0f;
            this.rightEar.zRot = 0.0f;
            this.leftEar.zRot = 0.0f;
        } else {
            this.body.xRot = -1.5707964f;
            this.frontRightLeg.xRot = this.backRightLeg.xRot = -this.body.xRot;
            this.backLeftLeg.xRot = this.backRightLeg.xRot;
            this.frontLeftLeg.xRot = this.backRightLeg.xRot;
            this.leftEar.xRot = this.backRightLeg.xRot;
            this.rightEar.xRot = this.backRightLeg.xRot;
            this.head.xRot = 0.0f;
            this.head.yRot = 0.0f;
            this.rightEar.zRot = Mth.sin((float)ageInTicks) * 0.5f;
            this.leftEar.zRot = -this.rightEar.zRot;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

