/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityPaleArcher;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class ModelPaleArcher
extends HumanoidModel<EntityPaleArcher> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("pale_archer");

    public ModelPaleArcher(ModelPart part) {
        super(part);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 8).addBox(-4.0f, -12.0f, -4.0f, 8.0f, 4.0f, 8.0f, cubeDef).texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0692f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 20).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDef).texOffs(0, 16).addBox(-4.5f, -12.3f, -2.5f, 9.0f, 12.0f, 5.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 36).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubeDef), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 36).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubeDef), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        body.addOrReplaceChild("trail", CubeListBuilder.create().texOffs(0, 33).addBox(-4.0f, 2.0f, 1.0f, 8.0f, 7.0f, 4.0f, cubeDef), PartPose.offsetAndRotation((float)0.01f, (float)-1.0f, (float)-3.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityPaleArcher entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        if (entity.getMainHandItem().getItem() instanceof BowItem && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setupAnim(EntityPaleArcher entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (!entity.isAggressive()) {
            this.rightArm.xRot = this.leftArm.xRot = Mth.sqrt((float)((float)Math.atan(200.0f * limbSwing))) * limbSwingAmount + 0.1565f;
        }
        this.body.xRot = 0.1565f;
        this.rightArm.zRot = 0.2182f;
        this.leftArm.zRot = -0.2182f;
        this.leftArm.z = 0.0f;
        this.rightArm.z = 0.0f;
        this.hat.y = 2.0f;
        this.head.y = 2.0f;
        this.body.y = 14.0f;
        ItemStack itemstack = entity.getMainHandItem();
        if (entity.isAggressive() && (itemstack.isEmpty() || !(itemstack.getItem() instanceof BowItem))) {
            float f1 = Mth.sin((float)(this.attackTime * (float)Math.PI));
            float f2 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
            this.rightArm.yRot = f1 * 0.6f - 0.1f;
            this.leftArm.yRot = 0.1f - f1 * 0.6f;
            this.leftArm.xRot = -1.5707964f;
            this.rightArm.xRot = -1.5707964f;
            this.rightArm.xRot -= f1 * 1.2f - f2 * 0.4f;
            this.leftArm.xRot -= f1 * 1.2f - f2 * 0.4f;
            AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        }
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.getArm(arm);
        modelpart.x += f;
        modelpart.translateAndRotate(stack);
        modelpart.x -= f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

