/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityRobbin;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelRobbin
extends EntityModel<EntityRobbin> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("robbin");
    public final ModelPart body;
    public final ModelPart tail;
    public final ModelPart head;
    public final ModelPart leftWing;
    public final ModelPart rightWing;
    public final ModelPart leftLeg;
    public final ModelPart rightLeg;

    public ModelRobbin(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.tail = root.getChild("tail");
        this.leftWing = root.getChild("left_wing");
        this.rightWing = root.getChild("right_wing");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -4.0f, 4.0f, 4.0f, 4.0f, cubeDef), PartPose.offset((float)0.0f, (float)22.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 17).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)18.3f, (float)1.6f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(11, 14).addBox(-1.5f, -2.5f, -2.0f, 3.0f, 3.0f, 3.0f, cubeDef).texOffs(8, 11).addBox(-1.0f, -1.0f, -3.0f, 2.0f, 1.0f, 2.0f, cubeDef).texOffs(0, 8).addBox(-2.0f, -3.49f, 0.0f, 1.0f, 1.0f, 2.0f, cubeDef).texOffs(0, 11).addBox(1.0f, -3.49f, 0.0f, 1.0f, 1.0f, 2.0f, cubeDef), PartPose.offset((float)0.0f, (float)18.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 24).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 3.0f, 5.0f, cubeDef), PartPose.offset((float)-2.0f, (float)18.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(20, 24).addBox(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 5.0f, cubeDef), PartPose.offset((float)2.0f, (float)18.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(18, 0).addBox(-2.0f, 0.0f, -2.0f, 2.0f, 3.0f, 2.0f, cubeDef), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(8, 20).addBox(0.0f, 0.0f, -2.0f, 2.0f, 3.0f, 2.0f, cubeDef), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(EntityRobbin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.body.xRot = -0.2617994f;
        float r = -0.2617994f;
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.tail.xRot = f * 0.35f - r;
        if (!entity.onGround()) {
            float f1 = Mth.cos((float)(ageInTicks * 80.0f * ((float)Math.PI / 180))) / 1.5f - 0.5235988f;
            this.tail.yRot = 0.0f;
            this.rightWing.yRot = f1;
            this.leftWing.yRot = -f1;
            this.leftLeg.xRot = -0.62831855f;
            this.rightLeg.xRot = -0.62831855f;
            this.leftLeg.y = 20.5f;
            this.rightLeg.y = 20.5f;
            this.leftLeg.z = 0.95f;
            this.rightLeg.z = 0.95f;
        } else {
            this.tail.yRot = f * 0.4f;
            this.leftWing.yRot = 0.0f;
            this.rightWing.yRot = 0.0f;
            this.rightLeg.xRot = f;
            this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftLeg.y = 21.0f;
            this.rightLeg.y = 21.0f;
            this.leftLeg.z = 0.0f;
            this.rightLeg.z = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

