/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntityRollum;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class ModelRollum
extends EntityModel<EntityRollum> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("rollum");
    public final ModelPart Torso;
    public final ModelPart Head;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelRollum(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Torso = root.getChild("Torso");
        this.Head = this.Torso.getChild("Head");
        this.RightArm = this.Torso.getChild("RightArm");
        this.LeftArm = this.Torso.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Torso = partdefinition.addOrReplaceChild("Torso", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        Torso.addOrReplaceChild("Torso_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -14.0f, -2.8f, 16.0f, 14.0f, 12.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-0.2f, (float)0.48f, (float)0.0f, (float)0.0f));
        Torso.addOrReplaceChild("Hip", CubeListBuilder.create().texOffs(0, 26).addBox(-7.0f, 0.0f, -5.0f, 14.0f, 8.0f, 9.0f, cubeDef), PartPose.offset((float)0.0f, (float)-1.0f, (float)2.0f));
        Torso.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(38, 35).addBox(-5.0f, -4.0f, -9.0f, 10.0f, 7.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)-8.37f, (float)-4.7f));
        PartDefinition RightArm = Torso.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(56, 0).addBox(-7.0f, -4.0f, -7.0f, 7.0f, 7.0f, 9.0f, cubeDef), PartPose.offset((float)-7.9f, (float)-9.67f, (float)1.3f));
        RightArm.addOrReplaceChild("RightLowerArm", CubeListBuilder.create().texOffs(0, 43).addBox(-1.0f, -1.0f, -4.0f, 5.0f, 13.0f, 9.0f, cubeDef), PartPose.offset((float)-6.0f, (float)4.0f, (float)-3.0f));
        PartDefinition LeftArm = Torso.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(47, 17).addBox(0.0f, -4.0f, -5.0f, 7.0f, 7.0f, 9.0f, cubeDef), PartPose.offset((float)7.9f, (float)-9.67f, (float)-0.7f));
        LeftArm.addOrReplaceChild("LeftLowerArm", CubeListBuilder.create().texOffs(28, 50).addBox(-4.0f, -1.0f, -4.0f, 5.0f, 13.0f, 9.0f, cubeDef), PartPose.offset((float)6.0f, (float)4.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 65).addBox(-4.0f, 0.0f, -4.0f, 6.0f, 10.0f, 8.0f, cubeDef), PartPose.offset((float)-3.0f, (float)14.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(56, 50).addBox(-2.0f, 0.0f, -4.0f, 6.0f, 10.0f, 8.0f, cubeDef), PartPose.offset((float)3.0f, (float)14.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntityRollum entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.Torso.zRot = f * 0.05f;
        this.RightArm.xRot = f1;
        this.LeftArm.xRot = f;
        this.LeftArm.zRot = 0.0f;
        this.RightArm.zRot = 0.0f;
        this.LeftArm.yRot = 0.0f;
        this.RightArm.yRot = 0.0f;
        AnimationUtils.bobModelPart((ModelPart)this.RightArm, (float)ageInTicks, (float)1.0f);
        AnimationUtils.bobModelPart((ModelPart)this.LeftArm, (float)ageInTicks, (float)-1.0f);
        this.RightLeg.xRot = f * 1.4f;
        this.LeftLeg.xRot = f1 * 1.4f;
        this.setupAttackAnimation(entity, ageInTicks);
    }

    protected ModelPart getArm(HumanoidArm humanoidarm) {
        return this.RightArm;
    }

    private HumanoidArm getAttackArm(EntityRollum entity) {
        return entity.getMainArm();
    }

    protected void setupAttackAnimation(EntityRollum entity, float ageInTicks) {
        if (!(this.attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(entity);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.Torso.yRot = Mth.sin((float)(Mth.sqrt((float)f) * ((float)Math.PI * 2))) * 0.2f;
            this.RightArm.yRot += this.Torso.yRot;
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin((float)(f * (float)Math.PI));
            float f2 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.Head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.Torso.yRot * 2.0f;
            modelpart.zRot += Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

