/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.iceika;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.iceika.EntitySabear;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelSabear
extends EntityModel<EntitySabear> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("sabear");
    private final ModelPart RearLeftLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart RearRightLeg;
    private final ModelPart FrontRightLeg;
    private final ModelPart Head;
    private final ModelPart body;

    public ModelSabear(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.RearLeftLeg = root.getChild("RearLeftLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.RearRightLeg = root.getChild("RearRightLeg");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.Head = root.getChild("Head");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(22, 49).addBox(-2.0f, -1.0f, -4.0f, 5.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)14.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("RearLeftLeg", CubeListBuilder.create().texOffs(48, 18).addBox(-2.5f, 0.5f, -4.0f, 5.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)12.5f, (float)12.0f));
        partdefinition.addOrReplaceChild("RearRightLeg", CubeListBuilder.create().texOffs(44, 41).addBox(-2.5f, 0.5f, -4.0f, 5.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)12.5f, (float)12.0f));
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(0, 49).addBox(-2.5f, -1.5f, -3.0f, 5.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)14.5f, (float)-5.0f));
        partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 67).addBox(-3.0f, 3.25f, -10.8333f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 67).addBox(2.0f, 3.25f, -10.8333f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 60).addBox(-3.0f, -1.75f, -10.8333f, 6.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(42, 0).addBox(-5.0f, -4.75f, -6.8333f, 10.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 9).addBox(-6.0f, -5.75f, -4.8333f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 9).addBox(4.0f, -5.75f, -4.8333f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)8.75f, (float)-7.1667f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 26).addBox(-7.0f, -22.0f, -8.0f, 14.0f, 11.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-7.0f, -23.0f, 4.0f, 14.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EntitySabear entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.FrontLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.RearLeftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.FrontRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.RearRightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.RearLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RearRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

