/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.mortum.EntityBasilisk;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelBasilisk
extends EntityModel<EntityBasilisk> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("basilisk");
    private final ModelPart body;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart leg5;
    private final ModelPart leg6;

    public ModelBasilisk(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
        this.leg5 = root.getChild("leg5");
        this.leg6 = root.getChild("leg6");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-1.0f, -1.0f, -9.0f, 2.0f, 2.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 0).mirror().addBox(-5.0f, 1.0f, -17.0f, 10.0f, 6.0f, 7.0f, CubeDeformation.NONE).mirror(false).texOffs(56, 0).mirror().addBox(-1.0f, -1.0f, -6.0f, 2.0f, 2.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(56, 0).mirror().addBox(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(56, 0).mirror().addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, CubeDeformation.NONE).mirror(false).texOffs(56, 0).mirror().addBox(-1.0f, -1.0f, 3.0f, 2.0f, 2.0f, 2.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)0.0f, (float)11.0f, (float)3.0f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(32, 10).mirror().addBox(-5.0f, -9.0f, -12.0f, 10.0f, 16.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)-3.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-3.0f, (float)19.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)3.0f, (float)19.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-3.0f, (float)19.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)3.0f, (float)19.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-3.0f, (float)19.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 6.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)3.0f, (float)19.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(EntityBasilisk entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leg1.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leg2.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.leg3.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
        this.leg4.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leg5.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
        this.leg6.xRot = (float)(Math.cos((double)(limbSwing * 0.6662f) + Math.PI) * (double)1.4f * (double)limbSwingAmount);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg5.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leg6.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

