/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ModelEpiphite<T extends LivingEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("epiphite");
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart LeftFin;
    private final ModelPart RightFin;
    private final ModelPart SpineFin;
    private final ModelPart Tail;
    private final ModelPart TailFin;
    private final ModelPart BackLeftFoot;
    private final ModelPart BackRightFoot;
    private final ModelPart FrontRightFoot;
    private final ModelPart FrontLeftFoot;

    public ModelEpiphite(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.LeftFin = this.Body.getChild("LeftFin");
        this.RightFin = this.Body.getChild("RightFin");
        this.SpineFin = this.Body.getChild("SpineFin");
        this.Tail = this.Body.getChild("Tail");
        this.TailFin = this.Tail.getChild("TailFin");
        this.BackLeftFoot = this.Body.getChild("BackLeftFoot");
        this.BackRightFoot = this.Body.getChild("BackRightFoot");
        this.FrontRightFoot = this.Body.getChild("FrontRightFoot");
        this.FrontLeftFoot = this.Body.getChild("FrontLeftFoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 21).addBox(-2.0f, -2.0f, -4.0f, 4.0f, 4.0f, 4.0f, CubeDeformation.NONE).texOffs(30, 28).addBox(1.0f, -3.0f, -2.0f, 1.0f, 1.0f, 2.0f, CubeDeformation.NONE).texOffs(30, 31).addBox(-2.0f, -3.0f, -2.0f, 1.0f, 1.0f, 2.0f, CubeDeformation.NONE).texOffs(24, 28).addBox(2.0f, -1.0f, -2.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE).texOffs(0, 29).addBox(-3.0f, -1.0f, -2.0f, 1.0f, 3.0f, 2.0f, CubeDeformation.NONE).texOffs(6, 32).addBox(-2.0f, 2.0f, -4.0f, 1.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(10, 32).addBox(1.0f, 2.0f, -4.0f, 1.0f, 2.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)17.0f, (float)-4.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 10.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)18.0f, (float)-4.0f));
        PartDefinition LeftFin = Body.addOrReplaceChild("LeftFin", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)0.0f, (float)1.0f));
        LeftFin.addOrReplaceChild("leftfin_r1", CubeListBuilder.create().texOffs(6, 29).addBox(0.0f, -2.0f, 0.0f, 4.0f, 3.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f, (float)0.0f));
        PartDefinition RightFin = Body.addOrReplaceChild("RightFin", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)0.0f, (float)1.0f));
        RightFin.addOrReplaceChild("rightfin_r1", CubeListBuilder.create().texOffs(28, 11).addBox(-4.0f, -2.0f, 0.0f, 4.0f, 3.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3526f, (float)0.0f));
        PartDefinition SpineFin = Body.addOrReplaceChild("SpineFin", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.0f, (float)1.0f));
        SpineFin.addOrReplaceChild("spinefin_r1", CubeListBuilder.create().texOffs(16, 28).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 4.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(36, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-1.0f, (float)10.0f));
        Tail.addOrReplaceChild("TailFin", CubeListBuilder.create().texOffs(0, 14).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 0.0f, 7.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)1.0f, (float)2.0f));
        Body.addOrReplaceChild("BackLeftFoot", CubeListBuilder.create().texOffs(28, 0).addBox(0.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)1.0f, (float)1.0f, (float)9.5f));
        Body.addOrReplaceChild("BackRightFoot", CubeListBuilder.create().texOffs(26, 14).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)-1.0f, (float)1.0f, (float)9.5f));
        Body.addOrReplaceChild("FrontRightFoot", CubeListBuilder.create().texOffs(24, 21).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)-1.0f, (float)1.0f, (float)2.0f));
        Body.addOrReplaceChild("FrontLeftFoot", CubeListBuilder.create().texOffs(16, 21).addBox(0.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)1.0f, (float)1.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.BackRightFoot.xRot = this.FrontLeftFoot.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.FrontRightFoot.xRot = this.BackLeftFoot.xRot = -this.FrontLeftFoot.xRot;
        this.Tail.yRot = this.FrontLeftFoot.xRot * 0.5f;
        if (((LivingEntity)entity).swinging) {
            this.LeftFin.yRot = this.SpineFin.xRot = Mth.sin((float)(((float)((LivingEntity)entity).swingTime + ageInTicks - (float)Mth.floor((float)ageInTicks)) * (float)Math.PI / (float)entity.getCurrentSwingDuration())) * (80.0f + Mth.cos((float)(ageInTicks * 4.0f)) * 15.0f) * ((float)Math.PI / 180);
            this.RightFin.yRot = -this.SpineFin.xRot;
            this.TailFin.xRot = this.Tail.xRot = this.SpineFin.xRot * 0.5f;
        } else {
            this.Tail.xRot = 0.0f;
            this.TailFin.xRot = 0.0f;
            this.RightFin.yRot = 0.0f;
            this.SpineFin.xRot = 0.0f;
            this.LeftFin.yRot = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

