/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.eden.EntityGemFin;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelGemFin
extends EntityModel<EntityGemFin> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("gem_fin");
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart TailFin;

    public ModelGemFin(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Head = root.getChild("Head");
        this.TailFin = root.getChild("TailFin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(8, 15).addBox(0.0f, -6.0f, 0.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.5f, -4.0f, -2.0f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)-1.0f));
        PartDefinition RightFin = Body.addOrReplaceChild("RightFin", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)-1.0f, (float)1.0f));
        RightFin.addOrReplaceChild("RightFin_r1", CubeListBuilder.create().texOffs(16, 16).addBox(0.5f, 0.0f, -1.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition LeftFin = Body.addOrReplaceChild("LeftFin", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-1.0f, (float)1.0f));
        LeftFin.addOrReplaceChild("LeftFin_r1", CubeListBuilder.create().texOffs(8, 18).addBox(-0.5f, 0.0f, -1.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        Body.addOrReplaceChild("Hip", CubeListBuilder.create().texOffs(16, 11).addBox(-1.0f, -6.0f, 1.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)2.0f));
        partdefinition.addOrReplaceChild("TailFin", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, -4.0f, 0.0f, 0.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)4.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 11).addBox(-2.0f, -3.0f, -3.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)-3.0f));
        Head.addOrReplaceChild("LeftWhisker_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.3682f, 0.2875f, -1.0513f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-1.0f, (float)-3.0f, (float)0.2942f, (float)-0.1321f, (float)-0.4202f));
        Head.addOrReplaceChild("RightWhisker_r1", CubeListBuilder.create().texOffs(0, 11).addBox(-0.6567f, 0.361f, -1.0807f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-1.0f, (float)-3.0f, (float)0.3742f, (float)0.1574f, (float)0.3633f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(EntityGemFin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f;
        if (!entity.isInWater()) {
            f = 1.5f;
        }
        this.TailFin.yRot = -f * 0.45f * Mth.sin((float)(0.6f * ageInTicks));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.TailFin.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

