/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelMage<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("mage");
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart staffProng2;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart leftarm;
    private final ModelPart staffPole;
    private final ModelPart staffCap;
    private final ModelPart staffProng3;
    private final ModelPart staffProng1;
    private final ModelPart staffProng4;
    private final ModelPart head;
    private final ModelPart ray2;
    private final ModelPart ray1;
    private final ModelPart ray4;
    private final ModelPart ray3;

    public ModelMage(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.rightarm = root.getChild("rightarm");
        this.staffProng2 = root.getChild("staffProng2");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.leftarm = root.getChild("leftarm");
        this.staffPole = root.getChild("staffPole");
        this.staffCap = root.getChild("staffCap");
        this.staffProng3 = root.getChild("staffProng3");
        this.staffProng1 = root.getChild("staffProng1");
        this.staffProng4 = root.getChild("staffProng4");
        this.head = root.getChild("head");
        this.ray2 = root.getChild("ray2");
        this.ray1 = root.getChild("ray1");
        this.ray4 = root.getChild("ray4");
        this.ray3 = root.getChild("ray3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(10, 23).mirror().addBox(-6.0f, 4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)2.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("staffProng2", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(4.0f, -7.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 12).mirror().addBox(-2.0f, 10.0f, -6.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 12).mirror().addBox(-2.0f, 10.0f, -6.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(10, 23).mirror().addBox(1.0f, 4.0f, -4.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffPole", CubeListBuilder.create().texOffs(53, 0).mirror().addBox(2.0f, -4.0f, -5.0f, 2.0f, 22.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffCap", CubeListBuilder.create().texOffs(40, 25).mirror().addBox(1.0f, -5.0f, -6.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProng3", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(1.0f, -7.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProng1", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(4.0f, -7.0f, -6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProng4", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(1.0f, -7.0f, -6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("ray2", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-7.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("ray1", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-1.0f, 6.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("ray4", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(5.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("ray3", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-1.0f, -7.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.ray3.zRot = this.ray4.zRot = ageInTicks / 10.0f;
        this.ray2.zRot = this.ray4.zRot;
        this.ray1.zRot = this.ray4.zRot;
        this.leftleg.xRot = this.rightarm.xRot = Mth.cos((float)limbSwing) * limbSwingAmount * 1.2f;
        this.staffProng3.xRot = this.staffProng4.xRot = Mth.cos((float)(limbSwing + (float)Math.PI)) * limbSwingAmount * 1.2f;
        this.staffProng2.xRot = this.staffProng4.xRot;
        this.staffProng1.xRot = this.staffProng4.xRot;
        this.staffCap.xRot = this.staffProng4.xRot;
        this.staffPole.xRot = this.staffProng4.xRot;
        this.leftarm.xRot = this.staffProng4.xRot;
        this.rightleg.xRot = this.staffProng4.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProng2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffPole.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffCap.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProng3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProng1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProng4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

