/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelMegalith<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("megalith");
    private final ModelPart torso;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart rightHand;
    private final ModelPart leftArm;
    private final ModelPart leftHand;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart upperBody;
    private final ModelPart head;

    public ModelMegalith(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.torso = root.getChild("torso");
        this.body = root.getChild("body");
        this.rightArm = root.getChild("rightArm");
        this.rightHand = root.getChild("rightHand");
        this.leftArm = root.getChild("leftArm");
        this.leftHand = root.getChild("leftHand");
        this.rightLeg = root.getChild("rightLeg");
        this.leftLeg = root.getChild("leftLeg");
        this.upperBody = root.getChild("upperBody");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-8.0f, (float)-8.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 20.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-10.0f, (float)-20.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(30, 42).mirror().addBox(-3.0f, 3.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-13.0f, (float)-32.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        partdefinition.addOrReplaceChild("rightHand", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-4.5f, 19.0f, -4.5f, 9.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-13.0f, (float)-32.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(30, 42).mirror().addBox(-3.0f, 3.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)13.0f, (float)-32.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        partdefinition.addOrReplaceChild("leftHand", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-4.5f, 19.0f, -4.5f, 9.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)13.0f, (float)-32.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(54, 38).mirror().addBox(-4.0f, 0.0f, -5.0f, 8.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-6.0f, (float)8.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(54, 38).mirror().addBox(-4.0f, 0.0f, -5.0f, 8.0f, 16.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)6.0f, (float)8.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("upperBody", CubeListBuilder.create().texOffs(112, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 22.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-11.0f, (float)-32.0f, (float)-7.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 49).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-41.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.rightHand.xRot = this.rightArm.xRot = Mth.cos((float)limbSwing) * limbSwingAmount;
        this.leftLeg.xRot = this.rightArm.xRot;
        this.leftHand.xRot = this.leftArm.xRot = Mth.cos((float)(limbSwing + (float)Math.PI)) * limbSwingAmount * 0.7f;
        this.rightLeg.xRot = this.leftArm.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightHand.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftHand.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.upperBody.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

