/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.wildwood.EntityMoonWolf;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelMoonWolf
extends EntityModel<EntityMoonWolf> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("moon_wolf");
    public final ModelPart Body;
    public final ModelPart Head;
    public final ModelPart BackRightLeg;
    public final ModelPart BackLeftLeg;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontLeftLeg;
    public final ModelPart Tail;

    public ModelMoonWolf(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Head = root.getChild("Head");
        this.FrontRightLeg = root.getChild("FrontRightLeg");
        this.FrontLeftLeg = root.getChild("FrontLeftLeg");
        this.BackRightLeg = root.getChild("BackRightLeg");
        this.BackLeftLeg = root.getChild("BackLeftLeg");
        this.Tail = root.getChild("Tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartPose zPose = PartPose.ZERO;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create(), zPose);
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create(), zPose);
        Head.addOrReplaceChild("RightEar_r1", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, -5.0f, -1.5f, 2.0f, 4.0f, 1.0f, cubeDef), PartPose.offsetAndRotation((float)-1.0f, (float)-3.0f, (float)-1.5f, (float)0.1745f, (float)0.5236f, (float)0.0f));
        Head.addOrReplaceChild("LeftEar_r1", CubeListBuilder.create().texOffs(13, 18).addBox(0.0f, -5.0f, -1.5f, 2.0f, 4.0f, 1.0f, cubeDef), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)-1.5f, (float)0.1745f, (float)-0.5236f, (float)0.0f));
        Head.addOrReplaceChild("HeadBase_r1", CubeListBuilder.create().texOffs(0, 18).addBox(-1.5f, -3.0f, -3.5f, 3.0f, 6.0f, 7.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-4.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        Head.addOrReplaceChild("Hair_r1", CubeListBuilder.create().texOffs(0, 31).addBox(-2.0f, -20.5f, -1.0f, 4.0f, 4.0f, 6.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)5.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        Body.addOrReplaceChild("BodyBase", CubeListBuilder.create().texOffs(0, 44).addBox(-3.0f, -6.0f, -6.01f, 6.0f, 6.0f, 0.0f, cubeDef).texOffs(0, 0).addBox(-3.0f, -6.0f, -6.0f, 6.0f, 6.0f, 12.0f, cubeDef), zPose);
        partdefinition.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, cubeDef), zPose);
        partdefinition.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(26, 27).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, cubeDef), zPose);
        partdefinition.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, cubeDef), zPose);
        partdefinition.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(20, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, cubeDef), zPose);
        PartDefinition Tail = partdefinition.addOrReplaceChild("Tail", CubeListBuilder.create(), zPose);
        PartDefinition LeftTail = Tail.addOrReplaceChild("LeftTail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)2.0f));
        LeftTail.addOrReplaceChild("LeftTail_r1", CubeListBuilder.create().texOffs(48, -8).addBox(1.0f, -7.0f, -1.0f, 0.0f, 8.0f, 8.0f, cubeDef), PartPose.rotation((float)0.384f, (float)0.2007f, (float)0.1658f));
        PartDefinition RightTail = Tail.addOrReplaceChild("RightTail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)2.0f));
        RightTail.addOrReplaceChild("RightTail_r1", CubeListBuilder.create().texOffs(48, 2).addBox(-1.0f, -7.0f, -1.0f, 0.0f, 8.0f, 8.0f, cubeDef), PartPose.rotation((float)0.384f, (float)-0.2007f, (float)-0.1658f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityMoonWolf entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.Head.zRot = entity.getHeadRollAngle(partialTicks) + entity.getBodyRollAngle(partialTicks, 0.0f);
        this.Body.zRot = entity.getBodyRollAngle(partialTicks, -0.16f);
        this.Tail.zRot = entity.getBodyRollAngle(partialTicks, -0.2f);
    }

    public void setupAnim(EntityMoonWolf entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Tail.yRot = entity.isAngry() ? 0.0f : f;
        if (entity.isInSittingPose()) {
            this.Head.setPos(0.0f, 12.0f, -2.0f);
            this.Body.setPos(0.0f, 20.0f, -2.0f);
            this.Body.xRot = -0.7853982f;
            this.Tail.setPos(0.0f, 21.0f, 6.0f);
            this.BackRightLeg.setPos(-1.99f, 23.0f, 2.0f);
            this.BackLeftLeg.setPos(1.99f, 23.0f, 2.0f);
            this.BackLeftLeg.xRot = 4.712389f;
            this.BackRightLeg.xRot = 4.712389f;
            this.FrontRightLeg.setPos(-1.9375f, 15.0f, -4.0f);
            this.FrontLeftLeg.setPos(1.9375f, 15.0f, -4.0f);
            this.FrontLeftLeg.xRot = 5.811947f;
            this.FrontRightLeg.xRot = 5.811947f;
        } else {
            this.Head.setPos(0.0f, 11.0f, -5.0f);
            this.Body.setPos(0.0f, 15.0f, 0.0f);
            this.Body.xRot = 0.0f;
            this.Tail.setPos(0.0f, 10.0f, 6.0f);
            this.BackRightLeg.setPos(-2.0f, 15.0f, 5.0f);
            this.BackLeftLeg.setPos(2.0f, 15.0f, 5.0f);
            this.FrontRightLeg.setPos(-2.0f, 15.0f, -5.0f);
            this.FrontLeftLeg.setPos(2.0f, 15.0f, -5.0f);
            this.BackRightLeg.xRot = this.FrontLeftLeg.xRot = f;
            this.BackLeftLeg.xRot = this.FrontRightLeg.xRot = f1;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.BackLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.FrontLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

