/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelSorcerer<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("sorcerer");
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart staffProngRight2;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart leftarm;
    private final ModelPart staffPoleRight;
    private final ModelPart staffCapRight;
    private final ModelPart staffProngRight3;
    private final ModelPart staffProngRight1;
    private final ModelPart staffProngRight4;
    private final ModelPart head;
    private final ModelPart ray2;
    private final ModelPart ray8;
    private final ModelPart ray6;
    private final ModelPart ray4;
    private final ModelPart ray1;
    private final ModelPart ray7;
    private final ModelPart ray5;
    private final ModelPart ray3;
    private final ModelPart staffPoleLeft;
    private final ModelPart staffCapLeft;
    private final ModelPart staffProngLeft1;
    private final ModelPart staffProngLeft2;
    private final ModelPart staffProngLeft4;
    private final ModelPart staffProngLeft3;

    public ModelSorcerer(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.rightarm = root.getChild("rightarm");
        this.staffProngRight2 = root.getChild("staffProngRight2");
        this.rightleg = root.getChild("rightleg");
        this.leftleg = root.getChild("leftleg");
        this.leftarm = root.getChild("leftarm");
        this.staffPoleRight = root.getChild("staffPoleRight");
        this.staffCapRight = root.getChild("staffCapRight");
        this.staffProngRight3 = root.getChild("staffProngRight3");
        this.staffProngRight1 = root.getChild("staffProngRight1");
        this.staffProngRight4 = root.getChild("staffProngRight4");
        this.head = root.getChild("head");
        this.ray2 = root.getChild("ray2");
        this.ray8 = root.getChild("ray8");
        this.ray6 = root.getChild("ray6");
        this.ray4 = root.getChild("ray4");
        this.ray1 = root.getChild("ray1");
        this.ray7 = root.getChild("ray7");
        this.ray5 = root.getChild("ray5");
        this.ray3 = root.getChild("ray3");
        this.staffPoleLeft = root.getChild("staffPoleLeft");
        this.staffCapLeft = root.getChild("staffCapLeft");
        this.staffProngLeft1 = root.getChild("staffProngLeft1");
        this.staffProngLeft2 = root.getChild("staffProngLeft2");
        this.staffProngLeft4 = root.getChild("staffProngLeft4");
        this.staffProngLeft3 = root.getChild("staffProngLeft3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(10, 23).mirror().addBox(-6.0f, 4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)2.0f, (float)-2.0f));
        partdefinition.addOrReplaceChild("staffProngRight2", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(-3.0f, -7.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 12).mirror().addBox(-2.0f, 10.0f, -6.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 12).mirror().addBox(-2.0f, 10.0f, -6.0f, 4.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(10, 23).mirror().addBox(1.0f, 4.0f, -4.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffPoleRight", CubeListBuilder.create().texOffs(53, 0).mirror().addBox(-5.0f, -4.0f, -5.0f, 2.0f, 22.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffCapRight", CubeListBuilder.create().texOffs(40, 25).mirror().addBox(-6.0f, -5.0f, -6.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProngRight3", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(-6.0f, -7.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProngRight1", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(-3.0f, -7.0f, -6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProngRight4", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(-6.0f, -7.0f, -6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("ray2", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-7.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        partdefinition.addOrReplaceChild("ray8", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-1.0f, 6.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        partdefinition.addOrReplaceChild("ray6", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(5.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        partdefinition.addOrReplaceChild("ray4", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-1.0f, -7.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        partdefinition.addOrReplaceChild("ray1", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-1.0f, 6.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("ray7", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(5.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("ray5", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-1.0f, -7.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("ray3", CubeListBuilder.create().texOffs(0, 23).mirror().addBox(-7.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-9.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("staffPoleLeft", CubeListBuilder.create().texOffs(53, 0).mirror().addBox(2.0f, -4.0f, -5.0f, 2.0f, 22.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffCapLeft", CubeListBuilder.create().texOffs(40, 25).mirror().addBox(1.0f, -5.0f, -6.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProngLeft1", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(4.0f, -7.0f, -6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProngLeft2", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(4.0f, -7.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProngLeft4", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(1.0f, -7.0f, -6.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("staffProngLeft3", CubeListBuilder.create().texOffs(40, 20).mirror().addBox(1.0f, -7.0f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.ray5.zRot = this.ray7.zRot = ageInTicks / 10.0f;
        this.ray3.zRot = this.ray7.zRot;
        this.ray1.zRot = this.ray7.zRot;
        this.ray6.zRot = this.ray8.zRot = ageInTicks / 10.0f - 0.7853982f;
        this.ray4.zRot = this.ray8.zRot;
        this.ray2.zRot = this.ray8.zRot;
        this.staffProngRight3.xRot = this.staffProngRight4.xRot = Mth.cos((float)limbSwing) * limbSwingAmount * 1.2f;
        this.staffProngRight2.xRot = this.staffProngRight4.xRot;
        this.staffProngRight1.xRot = this.staffProngRight4.xRot;
        this.staffCapRight.xRot = this.staffProngRight4.xRot;
        this.staffPoleRight.xRot = this.staffProngRight4.xRot;
        this.rightarm.xRot = this.staffProngRight4.xRot;
        this.leftleg.xRot = this.staffProngRight4.xRot;
        this.staffProngLeft3.xRot = this.staffProngLeft4.xRot = Mth.cos((float)(limbSwing + (float)Math.PI)) * limbSwingAmount * 1.2f;
        this.staffProngLeft2.xRot = this.staffProngLeft4.xRot;
        this.staffProngLeft1.xRot = this.staffProngLeft4.xRot;
        this.staffCapLeft.xRot = this.staffProngLeft4.xRot;
        this.staffPoleLeft.xRot = this.staffProngLeft4.xRot;
        this.leftarm.xRot = this.staffProngLeft4.xRot;
        this.rightleg.xRot = this.staffProngLeft4.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProngRight2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffPoleRight.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffCapRight.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProngRight3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProngRight1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProngRight4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray8.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray6.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray7.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray5.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.ray3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffPoleLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffCapLeft.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProngLeft1.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProngLeft2.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProngLeft4.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.staffProngLeft3.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

