/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.eden.EntitySunArcher;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;

public class ModelSunArcher
extends HumanoidModel<EntitySunArcher> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("sun_archer");
    public final ModelPart cloak;

    public ModelSunArcher(ModelPart part) {
        super(part);
        this.cloak = this.body.getChild("cloak");
    }

    public static LayerDefinition createBodyLayer() {
        CubeDeformation cubeDef = CubeDeformation.NONE;
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDef, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartPose zPose = PartPose.ZERO;
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(50, 35).addBox(-4.0f, -6.99f, -3.9f, 8.0f, 7.0f, 1.0f, cubeDef).texOffs(28, 13).addBox(-3.0f, 0.01f, -3.9f, 6.0f, 2.0f, 1.0f, cubeDef).texOffs(26, 62).addBox(-2.0f, 2.01f, -3.9f, 4.0f, 6.0f, 0.0f, cubeDef).texOffs(18, 17).addBox(-3.5f, -3.99f, -3.5f, 7.0f, 3.0f, 7.0f, cubeDef), zPose);
        hat.addOrReplaceChild("lower_left_ray", CubeListBuilder.create().texOffs(46, 24).addBox(-0.42f, -1.0f, 0.0f, 6.0f, 3.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)3.0f, (float)-4.0f, (float)-3.15f, (float)0.0f, (float)-0.34906587f, (float)0.0f));
        hat.addOrReplaceChild("upper_left_ray", CubeListBuilder.create().texOffs(58, 24).addBox(-0.42f, -3.0f, 0.0f, 6.0f, 3.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)3.0f, (float)-4.0f, (float)-2.15f, (float)0.3368f, (float)-0.5198f, (float)-0.614f));
        hat.addOrReplaceChild("middle_ray", CubeListBuilder.create().texOffs(34, 62).addBox(-1.0f, -6.0f, 0.0f, 3.0f, 6.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)-0.5f, (float)-6.0f, (float)-3.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        hat.addOrReplaceChild("upper_right_ray", CubeListBuilder.create().texOffs(0, 60).addBox(-5.58f, -3.0f, 0.0f, 6.0f, 3.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-2.15f, (float)0.3368f, (float)0.5198f, (float)0.614f));
        hat.addOrReplaceChild("lower_right_ray", CubeListBuilder.create().texOffs(52, 59).addBox(-5.58f, -1.0f, 0.0f, 6.0f, 3.0f, 0.0f, cubeDef), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-3.15f, (float)0.0f, (float)0.34906587f, (float)0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(18, 27).addBox(-3.0f, -5.99f, -3.0f, 6.0f, 6.0f, 6.0f, cubeDef), zPose);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -3.0f, 10.0f, 13.0f, 4.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)1.0f));
        body.addOrReplaceChild("right_cloak_pad", CubeListBuilder.create().texOffs(42, 27).addBox(-6.0f, -2.0f, -2.0f, 6.0f, 3.0f, 5.0f, cubeDef), PartPose.offsetAndRotation((float)-3.58f, (float)1.38f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        body.addOrReplaceChild("left_cloak_pad", CubeListBuilder.create().texOffs(46, 0).addBox(0.0f, -2.0f, -2.0f, 6.0f, 3.0f, 5.0f, cubeDef), PartPose.offsetAndRotation((float)3.58f, (float)1.38f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(28, 0).addBox(-2.5f, 0.0f, -2.0f, 5.0f, 9.0f, 4.0f, cubeDef).texOffs(0, 52).addBox(-2.5f, 9.0f, -1.0f, 4.0f, 5.0f, 3.0f, cubeDef), PartPose.offset((float)-2.5f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 39).addBox(-2.5f, 0.0f, -2.0f, 5.0f, 9.0f, 4.0f, cubeDef).texOffs(26, 54).addBox(-1.5f, 9.0f, -1.0f, 4.0f, 5.0f, 3.0f, cubeDef), PartPose.offset((float)2.5f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(50, 43).addBox(-4.0f, -1.5f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDef).texOffs(14, 54).addBox(-3.5f, 2.5f, -1.5f, 3.0f, 7.0f, 3.0f, cubeDef).texOffs(18, 39).addBox(-4.0f, 9.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDef).texOffs(46, 16).addBox(-4.5f, 7.5f, -2.5f, 5.0f, 3.0f, 5.0f, cubeDef), zPose);
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(50, 51).addBox(0.0f, -1.5f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDef).texOffs(40, 59).addBox(0.5f, 2.5f, -1.5f, 3.0f, 7.0f, 3.0f, cubeDef).texOffs(46, 8).addBox(-0.5f, 7.5f, -2.5f, 5.0f, 3.0f, 5.0f, cubeDef).texOffs(34, 39).addBox(0.0f, 9.0f, -2.0f, 4.0f, 11.0f, 4.0f, cubeDef), zPose);
        PartDefinition cloak = body.addOrReplaceChild("cloak", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)1.0f));
        cloak.addOrReplaceChild("cloak_rot", CubeListBuilder.create().texOffs(0, 17).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 21.0f, 1.0f, cubeDef), PartPose.rotation((float)0.0436f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void prepareMobModel(EntitySunArcher entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        if (entity.getMainHandItem().getItem() instanceof BowItem && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
        this.hat.visible = entity.getHealth() > entity.getMaxHealth() / 2.0f;
    }

    public void setupAnim(EntitySunArcher entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.cloak.xRot = Mth.sqrt((float)((float)Math.atan(200.0f * limbSwing))) * limbSwingAmount;
        this.body.y = -3.0f;
        this.hat.y = -3.0f;
        this.head.y = -3.0f;
        this.leftArm.y = -1.5f;
        this.rightArm.y = -1.5f;
        this.leftLeg.y = 10.0f;
        this.rightLeg.y = 10.0f;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? -1.0f : 1.0f;
        ModelPart modelpart = this.getArm(arm);
        modelpart.x += f;
        modelpart.translateAndRotate(stack);
        modelpart.x -= f;
        stack.translate(0.0f, 0.5f, 0.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.hat.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

