/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityBaseTomo;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelTomo
extends EntityModel<EntityBaseTomo> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("apalachia_tomo");
    public final ModelPart body;
    public final ModelPart rightAntenna;
    public final ModelPart leftAntenna;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;

    public ModelTomo(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.rightAntenna = this.body.getChild("right_antenna");
        this.leftAntenna = this.body.getChild("left_antenna");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
        this.rightLeg = root.getChild("right_leg");
        this.leftLeg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -7.0f, -4.0f, 12.0f, 8.0f, 9.0f, cubeDef).texOffs(0, 17).addBox(-6.0f, -7.0f, -5.0f, 12.0f, 8.0f, 1.0f, cubeDef), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition rightAntenna = body.addOrReplaceChild("right_antenna", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-6.0f, (float)0.0f));
        rightAntenna.addOrReplaceChild("right_antenna_rot", CubeListBuilder.create().texOffs(37, 37).addBox(-1.5f, -6.5f, -3.0f, 3.0f, 3.0f, 3.0f, cubeDef).texOffs(28, 32).addBox(-1.5f, -5.0f, -1.5f, 3.0f, 5.0f, 3.0f, cubeDef).texOffs(38, 20).addBox(-2.0f, -7.0f, -2.5f, 4.0f, 4.0f, 2.0f, cubeDef), PartPose.rotation((float)0.08726647f, (float)0.17453294f, (float)-0.19634955f));
        PartDefinition leftAntenna = body.addOrReplaceChild("left_antenna", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-6.0f, (float)0.0f));
        leftAntenna.addOrReplaceChild("left_antenna_rot", CubeListBuilder.create().texOffs(37, 29).addBox(-1.5f, -6.5f, -3.0f, 3.0f, 3.0f, 3.0f, cubeDef).texOffs(16, 32).addBox(-1.5f, -5.0f, -1.5f, 3.0f, 5.0f, 3.0f, cubeDef).texOffs(0, 36).addBox(-2.0f, -7.0f, -2.5f, 4.0f, 4.0f, 2.0f, cubeDef), PartPose.rotation((float)0.08726647f, (float)-0.17453294f, (float)0.19634955f));
        PartDefinition rightArm = body.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-5.0f, (float)-0.5f));
        rightArm.addOrReplaceChild("right_arm_rot", CubeListBuilder.create().texOffs(33, 0).addBox(-4.0f, -1.0f, -1.5f, 4.0f, 2.0f, 3.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.02359879f));
        PartDefinition leftArm = body.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)-5.0f, (float)-0.5f));
        leftArm.addOrReplaceChild("left_arm_rot", CubeListBuilder.create().texOffs(26, 17).addBox(0.0f, -1.0f, -1.5f, 4.0f, 2.0f, 3.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.0f, (float)-0.02359879f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(22, 22).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDef), PartPose.offset((float)-3.0f, (float)18.0f, (float)-1.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 26).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 6.0f, 4.0f, cubeDef), PartPose.offset((float)3.0f, (float)18.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)48);
    }

    public void setupAnim(EntityBaseTomo entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float g = ageInTicks * 0.1f + limbSwing * 0.5f;
        float g2 = 0.08f + limbSwingAmount * 0.4f;
        float f = -Mth.cos((float)(g * 1.2f)) * g2;
        float f1 = Mth.cos((float)g) * g2;
        float f2 = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.body.zRot = f2 * 0.8f;
        this.rightAntenna.zRot = this.leftArm.zRot = f;
        this.leftAntenna.zRot = this.rightArm.zRot = f1;
        this.rightLeg.xRot = f2 * 0.7f;
        this.leftLeg.xRot = -this.rightLeg.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

