/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.eden.EntityWeakCori;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelWeakCori
extends EntityModel<EntityWeakCori> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("weak_cori");
    public final ModelPart Head;
    public final ModelPart Tendrils;
    public final ModelPart FrontRightTendril;
    public final ModelPart FrontMiddleTendril;
    public final ModelPart FrontLeftTendril;
    public final ModelPart BackRightTendril;
    public final ModelPart BackMiddleTendril;
    public final ModelPart BackLeftTendril;
    public final ModelPart RightTendril;
    public final ModelPart LeftTendril;

    public ModelWeakCori(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Head = root.getChild("Head");
        this.Tendrils = root.getChild("Tendrils");
        this.FrontRightTendril = this.Tendrils.getChild("FrontRightTendril");
        this.FrontMiddleTendril = this.Tendrils.getChild("FrontMiddleTendril");
        this.FrontLeftTendril = this.Tendrils.getChild("FrontLeftTendril");
        this.BackRightTendril = this.Tendrils.getChild("BackRightTendril");
        this.BackMiddleTendril = this.Tendrils.getChild("BackMiddleTendril");
        this.BackLeftTendril = this.Tendrils.getChild("BackLeftTendril");
        this.RightTendril = this.Tendrils.getChild("RightTendril");
        this.LeftTendril = this.Tendrils.getChild("LeftTendril");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(40, 55).addBox(-4.0f, -6.0f, -1.0f, 8.0f, 8.0f, 1.0f, cubeDef).texOffs(13, 54).addBox(-5.0f, -7.0f, -0.5f, 10.0f, 10.0f, 0.0f, cubeDef), PartPose.offset((float)0.0f, (float)12.0f, (float)1.0f));
        Head.addOrReplaceChild("Skull", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -6.0f, -8.0f, 7.0f, 5.0f, 8.0f, cubeDef).texOffs(0, 22).addBox(-3.5f, -1.0f, -8.0f, 7.0f, 1.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        Head.addOrReplaceChild("Jaw", CubeListBuilder.create().texOffs(0, 13).addBox(-3.5f, -1.0f, -9.0f, 7.0f, 1.0f, 8.0f, cubeDef).texOffs(22, 5).addBox(-3.5f, 0.0f, -9.0f, 7.0f, 1.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition Tendrils = partdefinition.addOrReplaceChild("Tendrils", CubeListBuilder.create().texOffs(24, 16).addBox(-2.5f, 1.5f, -1.5f, 5.0f, 3.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)12.49f, (float)-1.5f));
        Tendrils.addOrReplaceChild("FrontRightTendril", CubeListBuilder.create().texOffs(0, 43).addBox(-2.5f, 0.5f, -3.0f, 3.0f, 9.0f, 3.0f, cubeDef), PartPose.offset((float)-2.0f, (float)4.0f, (float)-0.5f));
        Tendrils.addOrReplaceChild("FrontMiddleTendril", CubeListBuilder.create().texOffs(44, 0).addBox(-1.5f, 0.5f, -3.0f, 3.0f, 9.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)4.0f, (float)-0.5f));
        Tendrils.addOrReplaceChild("FrontLeftTendril", CubeListBuilder.create().texOffs(21, 40).addBox(0.0f, 0.5f, -3.0f, 3.0f, 9.0f, 3.0f, cubeDef), PartPose.offset((float)1.5f, (float)4.0f, (float)-0.5f));
        Tendrils.addOrReplaceChild("BackRightTendril", CubeListBuilder.create().texOffs(36, 37).addBox(-3.0f, 0.5f, 0.0f, 3.0f, 9.0f, 3.0f, cubeDef), PartPose.offset((float)-1.5f, (float)4.0f, (float)3.5f));
        Tendrils.addOrReplaceChild("BackMiddleTendril", CubeListBuilder.create().texOffs(12, 31).addBox(-1.5f, 0.5f, 0.0f, 3.0f, 9.0f, 3.0f, cubeDef), PartPose.offset((float)0.0f, (float)4.0f, (float)3.5f));
        Tendrils.addOrReplaceChild("BackLeftTendril", CubeListBuilder.create().texOffs(39, 25).addBox(0.0f, 0.5f, 0.0f, 3.0f, 9.0f, 3.0f, cubeDef), PartPose.offset((float)1.5f, (float)4.0f, (float)3.5f));
        Tendrils.addOrReplaceChild("RightTendril", CubeListBuilder.create().texOffs(27, 28).addBox(-3.0f, 0.5f, -1.5f, 3.0f, 9.0f, 3.0f, cubeDef), PartPose.offset((float)-1.5f, (float)4.0f, (float)1.5f));
        Tendrils.addOrReplaceChild("LeftTendril", CubeListBuilder.create().texOffs(0, 31).addBox(0.0f, 0.5f, -1.5f, 3.0f, 9.0f, 3.0f, cubeDef), PartPose.offset((float)1.5f, (float)4.0f, (float)1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityWeakCori entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        float f = Mth.cos((float)(ageInTicks * 15.0f * ((float)Math.PI / 180))) * 1.5707964f * 0.25f;
        this.BackMiddleTendril.xRot = this.RightTendril.zRot = f + 0.5672f;
        this.FrontMiddleTendril.xRot = this.LeftTendril.zRot = -f - 0.5672f;
        this.FrontLeftTendril.xRot = this.BackLeftTendril.zRot = f - 0.3491f;
        this.FrontLeftTendril.zRot = this.BackLeftTendril.zRot;
        this.FrontRightTendril.xRot = this.BackLeftTendril.zRot;
        this.BackRightTendril.xRot = this.BackRightTendril.zRot = -f + 0.3491f;
        this.BackLeftTendril.xRot = this.BackRightTendril.zRot;
        this.FrontRightTendril.zRot = this.BackRightTendril.zRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Tendrils.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

