/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityAequorea;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelAequorea
extends EntityModel<EntityAequorea> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("aequorea");
    public final ModelPart body;
    public final ModelPart tentaclesRightX;
    public final ModelPart tentaclesRightZ;
    public final ModelPart tentaclesLeftX;
    public final ModelPart tentaclesLeftZ;

    public ModelAequorea(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.tentaclesRightX = this.body.getChild("tentacles_right_x");
        this.tentaclesRightZ = this.body.getChild("tentacles_right_z");
        this.tentaclesLeftX = this.body.getChild("tentacles_left_x");
        this.tentaclesLeftZ = this.body.getChild("tentacles_left_z");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartPose zPose = PartPose.ZERO;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -1.0f, -4.0f, 8.0f, 2.0f, 8.0f, cubeDef).texOffs(0, 10).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 3.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        body.addOrReplaceChild("tentacles_right_x", CubeListBuilder.create().texOffs(0, 10).addBox(1.0f, 0.0f, 3.0f, 1.0f, 6.0f, 0.0f, cubeDef).texOffs(2, 0).addBox(-3.0f, 0.0f, 1.0f, 1.0f, 6.0f, 0.0f, cubeDef).texOffs(0, 19).addBox(-2.0f, 0.0f, 2.0f, 1.0f, 8.0f, 0.0f, cubeDef), zPose);
        body.addOrReplaceChild("tentacles_right_z", CubeListBuilder.create().texOffs(4, 0).addBox(-2.0f, 0.0f, -2.0f, 0.0f, 7.0f, 1.0f, cubeDef), zPose);
        body.addOrReplaceChild("tentacles_left_x", CubeListBuilder.create().texOffs(6, 0).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 6.0f, 0.0f, cubeDef).texOffs(4, 19).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 9.0f, 0.0f, cubeDef), zPose);
        body.addOrReplaceChild("tentacles_left_z", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, -3.0f, 0.0f, 7.0f, 1.0f, cubeDef).texOffs(2, 19).addBox(3.0f, 0.0f, -2.0f, 0.0f, 8.0f, 1.0f, cubeDef).texOffs(6, 19).addBox(2.0f, 0.0f, 0.0f, 0.0f, 8.0f, 1.0f, cubeDef), zPose);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(EntityAequorea entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.tentaclesLeftX.xRot = this.tentaclesLeftZ.zRot = Mth.sin((float)(10.0f * ageInTicks / 57.295776f)) * 0.15f;
        this.tentaclesRightX.xRot = this.tentaclesRightZ.zRot = -this.tentaclesLeftX.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

