/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityCrawler;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelCaveCrawler
extends EntityModel<EntityCrawler> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("cave_crawler");
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;

    public ModelCaveCrawler(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)6.0f, (float)0.829f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("trail", CubeListBuilder.create().texOffs(20, 54).addBox(-3.5f, -1.0f, -2.0f, 9.0f, 6.0f, 4.0f, cubeDef), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -5.0f, 8.0f, 8.0f, 8.0f, cubeDef).texOffs(32, 3).addBox(-3.99f, -12.0f, -2.0f, 0.0f, 4.0f, 5.0f, cubeDef).texOffs(32, 7).addBox(-4.0f, -12.0f, -2.0f, 0.0f, 4.0f, 5.0f, cubeDef).texOffs(37, 3).addBox(3.99f, -12.0f, -2.0f, 0.0f, 4.0f, 5.0f, cubeDef).texOffs(37, 7).addBox(4.0f, -12.0f, -2.0f, 0.0f, 4.0f, 5.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)1.0f, (float)-0.829f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("jug", CubeListBuilder.create().texOffs(0, 40).addBox(-3.0f, -9.0f, 0.0f, 6.0f, 7.0f, 6.0f, cubeDef).texOffs(24, 47).addBox(-2.0f, -10.0f, 1.0f, 4.0f, 1.0f, 4.0f, cubeDef).texOffs(24, 40).addBox(-3.0f, -11.0f, 0.0f, 6.0f, 1.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 0).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDef).texOffs(24, 16).addBox(-4.0f, -2.0f, -6.0f, 4.0f, 8.0f, 4.0f, cubeDef), PartPose.offset((float)-3.99f, (float)-10.0f, (float)0.0f));
        body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(20, 28).addBox(0.0f, -2.0f, -6.0f, 4.0f, 8.0f, 4.0f, cubeDef).texOffs(0, 32).addBox(0.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, cubeDef), PartPose.offset((float)3.99f, (float)-10.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityCrawler entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.body.zRot = f * 0.05f;
        this.rightArm.xRot = f1 - 0.6327f;
        this.leftArm.xRot = f - 0.6327f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

