/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityCrab;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelCrab
extends EntityModel<EntityCrab> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("crab");
    public final ModelPart Body;
    public final ModelPart RightClaw;
    public final ModelPart LeftClaw;
    public final ModelPart BackRightLeg;
    public final ModelPart BackLeftLeg;
    public final ModelPart MiddleRightLeg;
    public final ModelPart MiddleLeftLeg;
    public final ModelPart FrontRightLeg;
    public final ModelPart FrontLeftLeg;

    public ModelCrab(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.RightClaw = this.Body.getChild("RightClaw");
        this.LeftClaw = this.Body.getChild("LeftClaw");
        this.BackRightLeg = this.Body.getChild("BackRightLeg");
        this.BackLeftLeg = this.Body.getChild("BackLeftLeg");
        this.MiddleRightLeg = this.Body.getChild("MiddleRightLeg");
        this.MiddleLeftLeg = this.Body.getChild("MiddleLeftLeg");
        this.FrontRightLeg = this.Body.getChild("FrontRightLeg");
        this.FrontLeftLeg = this.Body.getChild("FrontLeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -3.0f, -6.0f, 12.0f, 6.0f, 12.0f, cubeDef), PartPose.offset((float)0.0f, (float)18.0f, (float)2.0f));
        Body.addOrReplaceChild("RightClaw", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -2.0f, -6.0f, 4.0f, 5.0f, 6.0f, cubeDef), PartPose.offset((float)-6.0f, (float)1.0f, (float)-4.0f));
        Body.addOrReplaceChild("LeftClaw", CubeListBuilder.create().texOffs(20, 20).addBox(0.0f, -2.0f, -6.0f, 4.0f, 5.0f, 6.0f, cubeDef), PartPose.offset((float)6.0f, (float)1.0f, (float)-4.0f));
        Body.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(16, 31).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)-5.99f, (float)2.0f, (float)5.01f));
        Body.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)5.99f, (float)2.0f, (float)5.01f));
        Body.addOrReplaceChild("MiddleRightLeg", CubeListBuilder.create().texOffs(8, 29).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)-5.99f, (float)2.0f, (float)2.0f));
        Body.addOrReplaceChild("MiddleLeftLeg", CubeListBuilder.create().texOffs(0, 6).addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)5.99f, (float)2.0f, (float)2.0f));
        Body.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(0, 29).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)-5.99f, (float)2.0f, (float)-1.0f));
        Body.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(14, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offset((float)5.99f, (float)2.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityCrab entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.E)) * 1.4f * limbSwingAmount;
        float f2 = 0.19634955f + Mth.cos((float)(ageInTicks * 0.05f + limbSwing * 0.5f)) * (0.08f + limbSwingAmount * 0.1f);
        this.RightClaw.zRot = -f2;
        this.LeftClaw.zRot = f2;
        this.Body.zRot = f * 0.03f;
        this.MiddleRightLeg.xRot = this.BackRightLeg.xRot = f;
        this.FrontLeftLeg.xRot = this.BackRightLeg.xRot;
        this.MiddleLeftLeg.xRot = this.BackLeftLeg.xRot = f1;
        this.FrontRightLeg.xRot = this.BackLeftLeg.xRot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

