/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import divinerpg.entities.vanilla.end.EntityEnderSpider;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelEnderSpider
extends HierarchicalModel<EntityEnderSpider> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("ender_spider");
    public final ModelPart head;
    public final ModelPart rightMandible;
    public final ModelPart leftMandible;
    public final ModelPart body;
    public final ModelPart thorax;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart rightMiddleFrontLeg;
    public final ModelPart leftMiddleFrontLeg;
    public final ModelPart rightMiddleHindLeg;
    public final ModelPart leftMiddleHindLeg;
    public final ModelPart rightHindLeg;
    public final ModelPart leftHindLeg;

    public ModelEnderSpider(EntityRendererProvider.Context context) {
        this.body = context.bakeLayer(LAYER_LOCATION).getChild("body");
        this.head = this.body.getChild("head");
        this.rightMandible = this.head.getChild("right_mandible");
        this.leftMandible = this.head.getChild("left_mandible");
        this.thorax = this.body.getChild("thorax");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.rightMiddleFrontLeg = this.body.getChild("right_middle_front_leg");
        this.leftMiddleFrontLeg = this.body.getChild("left_middle_front_leg");
        this.rightMiddleHindLeg = this.body.getChild("right_middle_hind_leg");
        this.leftMiddleHindLeg = this.body.getChild("left_middle_hind_leg");
        this.rightHindLeg = this.body.getChild("right_hind_leg");
        this.leftHindLeg = this.body.getChild("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 4).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        head.addOrReplaceChild("right_mandible", CubeListBuilder.create().texOffs(24, 7).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 4.0f, 1.0f, cubeDef), PartPose.offset((float)-2.0f, (float)3.0f, (float)-9.0f));
        head.addOrReplaceChild("left_mandible", CubeListBuilder.create().texOffs(24, 7).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 1.0f, cubeDef), PartPose.offset((float)2.0f, (float)3.0f, (float)-8.0f));
        body.addOrReplaceChild("thorax", CubeListBuilder.create().texOffs(0, 12).addBox(-5.0f, -4.0f, 0.0f, 10.0f, 8.0f, 12.0f, cubeDef).texOffs(8, 40).addBox(-4.0f, -7.0f, 2.0f, 8.0f, 3.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        PartDefinition rightFrontLeg = body.addOrReplaceChild("right_front_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)-1.0f));
        PartDefinition rightFrontLegRot = rightFrontLeg.addOrReplaceChild("right_front_leg_rot", CubeListBuilder.create().texOffs(16, 36).addBox(-13.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.rotation((float)-0.6155f, (float)-0.5235988f, (float)0.1699f));
        rightFrontLegRot.addOrReplaceChild("right_front_lower_leg", CubeListBuilder.create().texOffs(8, 32).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3926991f));
        PartDefinition leftFrontLeg = body.addOrReplaceChild("left_front_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)0.0f, (float)-1.0f));
        PartDefinition leftFrontLegRot = leftFrontLeg.addOrReplaceChild("left_front_leg_rot", CubeListBuilder.create().texOffs(16, 36).mirror().addBox(-1.0f, -1.0f, -1.0f, 14.0f, 2.0f, 2.0f, cubeDef), PartPose.rotation((float)-0.6155f, (float)0.5235988f, (float)-0.1699f));
        leftFrontLegRot.addOrReplaceChild("left_front_lower_leg", CubeListBuilder.create().texOffs(8, 32).mirror().addBox(0.0f, 0.0f, -1.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)13.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3926991f));
        PartDefinition rightMiddleFrontLeg = body.addOrReplaceChild("right_middle_front_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        rightMiddleFrontLeg.addOrReplaceChild("right_middle_front_leg_rot", CubeListBuilder.create().texOffs(18, 0).addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.rotation((float)0.0f, (float)-0.2617994f, (float)-0.6109f));
        PartDefinition leftMiddleFrontLeg = body.addOrReplaceChild("left_middle_front_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        leftMiddleFrontLeg.addOrReplaceChild("left_middle_front_leg_rot", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.rotation((float)0.0f, (float)0.2617994f, (float)0.6109f));
        PartDefinition rightMiddleHindLeg = body.addOrReplaceChild("right_middle_hind_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)1.0f));
        rightMiddleHindLeg.addOrReplaceChild("right_middle_hind_leg_rot", CubeListBuilder.create().texOffs(18, 0).addBox(-15.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.2617994f, (float)-0.6109f));
        PartDefinition leftMiddleHindLeg = body.addOrReplaceChild("left_middle_hind_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)0.0f, (float)1.0f));
        leftMiddleHindLeg.addOrReplaceChild("left_middle_hind_leg_rot", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)-0.2617994f, (float)0.6109f));
        PartDefinition rightHindLeg = body.addOrReplaceChild("right_hind_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)2.0f));
        rightHindLeg.addOrReplaceChild("right_hind_upper_leg", CubeListBuilder.create().texOffs(16, 32).addBox(-10.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5707964f));
        rightHindLeg.addOrReplaceChild("right_hind_lower_leg", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 25.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)2.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition leftHindLeg = body.addOrReplaceChild("left_hind_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)0.0f, (float)2.0f));
        leftHindLeg.addOrReplaceChild("left_hind_upper_leg", CubeListBuilder.create().texOffs(16, 32).mirror().addBox(0.0f, -1.0f, -1.0f, 10.0f, 2.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f));
        leftHindLeg.addOrReplaceChild("left_hind_lower_leg", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(0.0f, 0.0f, -1.0f, 2.0f, 25.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-2.0f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1781f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.body;
    }

    public void setupAnim(EntityEnderSpider entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        float f = limbSwing * 0.6662f;
        float f1 = -Mth.cos((float)(f * 2.0f)) * 0.4f * limbSwingAmount;
        float f2 = Mth.sin((float)(f * 2.0f)) * 0.4f * limbSwingAmount;
        float f3 = Math.abs(Mth.sin((float)f) * 0.4f) * limbSwingAmount;
        float f4 = Math.abs(Mth.cos((float)f) * 0.4f) * limbSwingAmount;
        this.thorax.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount;
        this.leftFrontLeg.yRot = f2;
        this.rightFrontLeg.yRot = -this.leftFrontLeg.yRot;
        this.rightFrontLeg.zRot = f4;
        this.leftFrontLeg.zRot = -this.rightFrontLeg.zRot;
        this.rightMiddleFrontLeg.yRot = f2;
        this.leftMiddleFrontLeg.yRot = -this.rightMiddleFrontLeg.yRot;
        this.rightMiddleFrontLeg.zRot = f4;
        this.leftMiddleFrontLeg.zRot = -this.rightMiddleFrontLeg.zRot;
        this.leftMiddleHindLeg.yRot = f1;
        this.rightMiddleHindLeg.yRot = -this.leftMiddleHindLeg.yRot;
        this.rightMiddleHindLeg.zRot = f3;
        this.leftMiddleHindLeg.zRot = -this.rightMiddleHindLeg.zRot;
        this.rightHindLeg.yRot = f1 + 0.7853982f;
        this.leftHindLeg.yRot = -this.rightHindLeg.yRot;
        this.rightHindLeg.zRot = f3 - 0.7853982f;
        this.leftHindLeg.zRot = -this.rightHindLeg.zRot;
    }
}

