/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.base.EntityDivineTameable;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelHusk
extends EntityModel<EntityDivineTameable> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("husk");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;

    public ModelHusk(EntityRendererProvider.Context context) {
        ModelPart r = context.bakeLayer(LAYER_LOCATION);
        this.root = r.getChild("root");
        this.head = this.root.getChild("head");
        this.leg0 = this.root.getChild("leg0");
        this.leg1 = this.root.getChild("leg1");
        this.leg2 = this.root.getChild("leg2");
        this.leg3 = this.root.getChild("leg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation pointone = new CubeDeformation(0.1f);
        CubeDeformation minuspointone = new CubeDeformation(-0.1f);
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)-1.0f));
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 28).addBox(-4.0f, -1.9f, -3.8f, 8.0f, 8.0f, 6.0f, CubeDeformation.NONE).texOffs(36, 52).addBox(-2.0f, -1.9f, -3.8f, 4.0f, 2.0f, 6.0f, pointone).texOffs(35, 5).addBox(-5.0f, 4.1f, -1.8f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE).texOffs(35, 0).addBox(-3.0f, 4.1f, -4.8f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE).texOffs(35, 5).addBox(4.0f, 4.1f, -1.8f, 1.0f, 3.0f, 1.0f, CubeDeformation.NONE).texOffs(35, 0).addBox(2.0f, 4.1f, -4.8f, 1.0f, 4.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-20.0f, (float)-8.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-19.0f, (float)2.0f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(34, 43).addBox(-2.0f, 15.0f, -6.0f, 4.0f, 3.0f, 6.0f, new CubeDeformation(0.11f)).texOffs(0, 52).addBox(-6.0f, 10.0f, -6.0f, 12.0f, 5.0f, 6.0f, pointone).texOffs(0, 42).addBox(-6.0f, 3.0f, -5.0f, 12.0f, 5.0f, 5.0f, pointone).texOffs(0, 0).addBox(-6.0f, 0.0f, -10.0f, 12.0f, 18.0f, 10.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-0.9f, (float)-7.8f, (float)1.309f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(28, 28).mirror().addBox(-2.0f, 2.1f, -2.0f, 4.0f, 10.0f, 4.0f, minuspointone).mirror(false), PartPose.offset((float)-4.0f, (float)-12.0f, (float)7.0f));
        root.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(28, 28).addBox(-2.0f, 2.1f, -2.0f, 4.0f, 10.0f, 4.0f, minuspointone), PartPose.offset((float)4.0f, (float)-12.0f, (float)7.0f));
        root.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(44, 28).mirror().addBox(-2.0f, 2.1f, -1.0f, 4.0f, 10.0f, 4.0f, minuspointone).mirror(false).texOffs(48, 42).mirror().addBox(-2.0f, 3.1f, -1.0f, 4.0f, 3.0f, 4.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-4.0f, (float)-12.0f, (float)-6.0f));
        root.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(44, 28).addBox(-2.0f, 2.1f, -1.0f, 4.0f, 10.0f, 4.0f, minuspointone).texOffs(48, 42).addBox(-2.0f, 3.1f, -1.0f, 4.0f, 3.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)4.0f, (float)-12.0f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityDivineTameable entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netheadYaw, float headPitch) {
        if (entity.isInSittingPose()) {
            this.leg1.yRot = -0.2f;
            this.leg0.yRot = 0.2f;
            this.leg0.y = -7.0f;
            this.leg1.y = -7.0f;
            this.leg0.z = 9.0f;
            this.leg1.z = 9.0f;
            this.root.y = 29.0f;
            this.leg0.xRot = -1.5707964f;
            this.leg1.xRot = -1.5707964f;
            this.leg2.xRot = -0.7853982f;
            this.leg3.xRot = -0.7853982f;
        } else {
            this.leg0.yRot = 0.0f;
            this.leg1.yRot = 0.0f;
            this.leg0.y = -12.0f;
            this.leg1.y = -12.0f;
            this.leg0.z = 7.0f;
            this.leg1.z = 7.0f;
            this.root.y = 24.0f;
            this.leg0.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)1.4f * (double)limbSwingAmount);
            this.leg1.xRot = -this.leg0.xRot;
            this.leg2.xRot = -this.leg0.xRot;
            this.leg3.xRot = this.leg0.xRot;
        }
        this.head.yRot = netheadYaw / 114.59155f;
        this.head.xRot = headPitch / 114.59155f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

