/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import divinerpg.entities.vanilla.overworld.EntityJungleSpider;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelJungleSpider
extends HierarchicalModel<EntityJungleSpider> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("jungle_spider");
    public final ModelPart head;
    public final ModelPart rightMandible;
    public final ModelPart leftMandible;
    public final ModelPart body;
    public final ModelPart thorax;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart rightMiddleFrontLeg;
    public final ModelPart leftMiddleFrontLeg;
    public final ModelPart rightMiddleHindLeg;
    public final ModelPart leftMiddleHindLeg;
    public final ModelPart rightHindLeg;
    public final ModelPart leftHindLeg;

    public ModelJungleSpider(EntityRendererProvider.Context context) {
        this.body = context.bakeLayer(LAYER_LOCATION).getChild("body");
        this.head = this.body.getChild("head");
        this.leftMandible = this.head.getChild("left_mandible");
        this.rightMandible = this.head.getChild("right_mandible");
        this.thorax = this.body.getChild("thorax");
        this.rightFrontLeg = this.body.getChild("right_front_leg");
        this.leftFrontLeg = this.body.getChild("left_front_leg");
        this.rightMiddleFrontLeg = this.body.getChild("right_middle_front_leg");
        this.leftMiddleFrontLeg = this.body.getChild("left_middle_front_leg");
        this.rightMiddleHindLeg = this.body.getChild("right_middle_hind_leg");
        this.leftMiddleHindLeg = this.body.getChild("left_middle_hind_leg");
        this.rightHindLeg = this.body.getChild("right_hind_leg");
        this.leftHindLeg = this.body.getChild("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 33).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 19).addBox(-4.0f, -4.0f, -7.99f, 8.0f, 8.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        head.addOrReplaceChild("right_mandible", CubeListBuilder.create().texOffs(16, 39).mirror().addBox(-1.0f, -1.0f, -1.5f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)-2.0f, (float)2.0f, (float)-8.0f, (float)0.0f, (float)0.3926991f, (float)0.0f));
        head.addOrReplaceChild("left_mandible", CubeListBuilder.create().texOffs(16, 39).addBox(-1.0f, -1.0f, -1.5f, 2.0f, 4.0f, 2.0f, cubeDef), PartPose.offsetAndRotation((float)2.0f, (float)2.0f, (float)-8.0f, (float)0.0f, (float)-0.3926991f, (float)0.0f));
        PartDefinition thorax = body.addOrReplaceChild("thorax", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        thorax.addOrReplaceChild("thorax_front_rot", CubeListBuilder.create().texOffs(32, 19).addBox(-4.0f, -4.0f, -0.5f, 8.0f, 8.0f, 6.0f, cubeDef), PartPose.rotation((float)0.17453294f, (float)0.0f, (float)0.0f));
        thorax.addOrReplaceChild("thorax_hind_rot", CubeListBuilder.create().texOffs(38, 0).mirror().addBox(-4.0f, 6.24f, 8.27f, 3.0f, 3.0f, 4.0f, cubeDef).texOffs(24, 39).mirror().addBox(-3.5f, 6.24f, 6.27f, 2.0f, 2.0f, 2.0f, cubeDef).texOffs(24, 39).addBox(1.5f, 6.24f, 6.27f, 2.0f, 2.0f, 2.0f, cubeDef).texOffs(38, 0).addBox(1.0f, 6.24f, 8.27f, 3.0f, 3.0f, 4.0f, cubeDef).texOffs(0, 0).addBox(-5.0f, -3.76f, 4.27f, 10.0f, 10.0f, 9.0f, cubeDef), PartPose.rotation((float)0.43633235f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontLeg = body.addOrReplaceChild("right_front_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)-2.0f));
        PartDefinition rightFrontLegRot = rightFrontLeg.addOrReplaceChild("right_front_leg_rot", CubeListBuilder.create().texOffs(0, 35).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, cubeDef).texOffs(0, 39).addBox(-13.0f, -3.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)-0.7853982f, (float)-0.3926991f));
        rightFrontLegRot.addOrReplaceChild("right_front_lower_leg", CubeListBuilder.create().texOffs(8, 39).addBox(-2.0f, -0.05f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)-13.0f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3926991f));
        PartDefinition leftFrontLeg = body.addOrReplaceChild("left_front_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)0.0f, (float)-2.0f));
        PartDefinition leftFrontLegRot = leftFrontLeg.addOrReplaceChild("left_front_leg_rot", CubeListBuilder.create().texOffs(0, 35).mirror().addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, cubeDef).texOffs(0, 39).mirror().addBox(11.0f, -3.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.7853982f, (float)0.3926991f));
        leftFrontLegRot.addOrReplaceChild("left_front_lower_leg", CubeListBuilder.create().texOffs(8, 39).mirror().addBox(0.0f, -0.05f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)13.0f, (float)0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3926991f));
        PartDefinition rightMiddleFrontLeg = body.addOrReplaceChild("right_middle_front_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)-1.0f));
        rightMiddleFrontLeg.addOrReplaceChild("right_middle_front_leg_rot", CubeListBuilder.create().texOffs(0, 35).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, cubeDef).texOffs(38, 7).addBox(-13.0f, -3.0f, -1.0f, 2.0f, 10.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)-0.2617994f, (float)-0.3054f));
        PartDefinition leftMiddleFrontLeg = body.addOrReplaceChild("left_middle_front_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)0.0f, (float)-1.0f));
        leftMiddleFrontLeg.addOrReplaceChild("left_middle_front_leg_rot", CubeListBuilder.create().texOffs(0, 35).mirror().addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, cubeDef).texOffs(38, 7).mirror().addBox(11.0f, -3.0f, -1.0f, 2.0f, 10.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.2617994f, (float)0.3054f));
        PartDefinition rightMiddleHindLeg = body.addOrReplaceChild("right_middle_hind_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)1.0f));
        rightMiddleHindLeg.addOrReplaceChild("right_middle_hind_leg_rot", CubeListBuilder.create().texOffs(0, 35).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, cubeDef).texOffs(38, 7).addBox(-13.0f, -3.0f, -1.0f, 2.0f, 10.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.2617994f, (float)-0.3054f));
        PartDefinition leftMiddleHindLeg = body.addOrReplaceChild("left_middle_hind_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)0.0f, (float)1.0f));
        leftMiddleHindLeg.addOrReplaceChild("left_middle_hind_leg_rot", CubeListBuilder.create().texOffs(0, 35).mirror().addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, cubeDef).texOffs(38, 7).mirror().addBox(11.0f, -3.0f, -1.0f, 2.0f, 10.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)-0.2617994f, (float)0.3054f));
        PartDefinition rightHindLeg = body.addOrReplaceChild("right_hind_leg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)2.0f));
        rightHindLeg.addOrReplaceChild("right_hind_leg_rot", CubeListBuilder.create().texOffs(0, 35).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, cubeDef).texOffs(38, 7).addBox(-13.0f, -3.0f, -1.0f, 2.0f, 10.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.7853982f, (float)-0.3926991f));
        PartDefinition leftHindLeg = body.addOrReplaceChild("left_hind_leg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)0.0f, (float)2.0f));
        leftHindLeg.addOrReplaceChild("left_hind_leg_rot", CubeListBuilder.create().texOffs(0, 35).mirror().addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, cubeDef).texOffs(38, 7).mirror().addBox(11.0f, -3.0f, -1.0f, 2.0f, 10.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)-0.7853982f, (float)0.3926991f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.body;
    }

    public void setupAnim(EntityJungleSpider entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        float f = limbSwing * 0.6662f;
        float f1 = -Mth.cos((float)(f * 2.0f)) * 0.4f * limbSwingAmount;
        float f2 = Mth.sin((float)(f * 2.0f)) * 0.4f * limbSwingAmount;
        float f3 = Math.abs(Mth.sin((float)f) * 0.4f) * limbSwingAmount;
        float f4 = Math.abs(Mth.cos((float)f) * 0.4f) * limbSwingAmount;
        if (entity.isAggressive() || !entity.onGround() && !entity.isClimbing() && !entity.isInWaterOrBubble()) {
            this.rightFrontLeg.zRot = 0.3926991f;
            this.rightMandible.yRot = 0.3926991f;
            this.leftMandible.yRot = -this.rightMandible.yRot;
            this.leftFrontLeg.xRot = -1.0471976f;
            this.rightFrontLeg.xRot = -1.0471976f;
        } else {
            this.leftFrontLeg.xRot = 0.0f;
            this.rightFrontLeg.xRot = 0.0f;
            this.leftMandible.yRot = 0.0f;
            this.rightMandible.yRot = 0.0f;
            this.rightFrontLeg.zRot = f4;
        }
        this.thorax.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.25f * limbSwingAmount;
        this.leftFrontLeg.yRot = f2;
        this.rightFrontLeg.yRot = -this.leftFrontLeg.yRot;
        this.leftFrontLeg.zRot = -this.rightFrontLeg.zRot;
        this.rightMiddleFrontLeg.yRot = f2;
        this.leftMiddleFrontLeg.yRot = -this.rightMiddleFrontLeg.yRot;
        this.rightMiddleFrontLeg.zRot = f4;
        this.leftMiddleFrontLeg.zRot = -this.rightMiddleFrontLeg.zRot;
        this.leftMiddleHindLeg.yRot = f1;
        this.rightMiddleHindLeg.yRot = -this.leftMiddleHindLeg.yRot;
        this.rightMiddleHindLeg.zRot = f3;
        this.leftMiddleHindLeg.zRot = -this.rightMiddleHindLeg.zRot;
        this.rightHindLeg.yRot = f1;
        this.leftHindLeg.yRot = -this.rightHindLeg.yRot;
        this.rightHindLeg.zRot = f3;
        this.leftHindLeg.zRot = -this.rightHindLeg.zRot;
    }
}

