/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityLiopleurodon;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelLiopleurodon
extends EntityModel<EntityLiopleurodon> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("liopleurodon");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart upperJaw;
    public final ModelPart lowerJaw;
    public final ModelPart rightFinFront;
    public final ModelPart leftFinFront;
    public final ModelPart rightFinHind;
    public final ModelPart leftFinHind;
    public final ModelPart tailFront;
    public final ModelPart tailHind;
    public final ModelPart tailFin;

    public ModelLiopleurodon(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.upperJaw = this.head.getChild("upper_jaw");
        this.lowerJaw = this.head.getChild("lower_jaw");
        this.rightFinFront = this.body.getChild("right_fin_front");
        this.leftFinFront = this.body.getChild("left_fin_front");
        this.rightFinHind = this.body.getChild("right_fin_hind");
        this.leftFinHind = this.body.getChild("left_fin_hind");
        this.tailFront = this.body.getChild("tail_front");
        this.tailHind = this.tailFront.getChild("tail_hind");
        this.tailFin = this.tailHind.getChild("tail_fin");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -4.0f, -8.0f, 9.0f, 9.0f, 20.0f, cubeDef), PartPose.offset((float)0.0f, (float)19.0f, (float)-2.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 58).addBox(-4.5f, -4.0f, -7.0f, 9.0f, 7.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-8.0f));
        PartDefinition upperJaw = head.addOrReplaceChild("upper_jaw", CubeListBuilder.create().texOffs(25, 50).addBox(-1.5f, -1.5f, -12.0f, 4.0f, 2.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.offset((float)-0.5f, (float)0.5f, (float)-7.0f));
        upperJaw.addOrReplaceChild("upper_teeth_right", CubeListBuilder.create().texOffs(60, 0).addBox(0.0f, 0.0f, -12.0f, 2.0f, 0.0f, 12.0f, cubeDef), PartPose.offsetAndRotation((float)-1.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.9634955f));
        upperJaw.addOrReplaceChild("upper_teeth_left", CubeListBuilder.create().texOffs(60, 0).mirror().addBox(-2.0f, 0.0f, -12.0f, 2.0f, 0.0f, 12.0f, cubeDef), PartPose.offsetAndRotation((float)2.5f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.9634955f));
        PartDefinition lowerJaw = head.addOrReplaceChild("lower_jaw", CubeListBuilder.create().texOffs(0, 29).addBox(-2.0f, -0.49f, -14.0f, 4.0f, 2.0f, 19.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)1.5f, (float)-5.0f));
        lowerJaw.addOrReplaceChild("lower_teeth_right", CubeListBuilder.create().texOffs(64, 0).addBox(0.0f, 0.0f, -12.0f, 1.0f, 0.0f, 12.0f, cubeDef), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-1.9634955f));
        lowerJaw.addOrReplaceChild("lower_teeth_left", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-1.0f, 0.0f, -12.0f, 1.0f, 0.0f, 12.0f, cubeDef), PartPose.offsetAndRotation((float)2.0f, (float)0.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)1.9634955f));
        PartDefinition rightFinFront = body.addOrReplaceChild("right_fin_front", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)3.0f, (float)-4.0f));
        rightFinFront.addOrReplaceChild("right_fin_front_rot", CubeListBuilder.create().texOffs(22, 64).addBox(-1.0f, -3.18f, -1.93f, 2.0f, 6.0f, 10.0f, cubeDef), PartPose.rotation((float)0.9599f, (float)0.0f, (float)-1.8675f));
        PartDefinition leftFinFront = body.addOrReplaceChild("left_fin_front", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)3.0f, (float)-4.0f));
        leftFinFront.addOrReplaceChild("left_fin_front_rot", CubeListBuilder.create().texOffs(22, 64).mirror().addBox(-1.0f, -3.18f, -1.93f, 2.0f, 6.0f, 10.0f, cubeDef), PartPose.rotation((float)0.9599f, (float)0.0f, (float)1.8675f));
        PartDefinition rightFinHind = body.addOrReplaceChild("right_fin_hind", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)3.0f, (float)11.0f));
        rightFinHind.addOrReplaceChild("right_fin_hind_rot", CubeListBuilder.create().texOffs(0, 72).mirror().addBox(-0.9f, -2.16f, -0.95f, 1.0f, 5.0f, 8.0f, cubeDef), PartPose.rotation((float)0.9599f, (float)0.0f, (float)-1.8675f));
        PartDefinition leftFinHind = body.addOrReplaceChild("left_fin_hind", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)3.0f, (float)11.0f));
        leftFinHind.addOrReplaceChild("left_fin_hind_rot", CubeListBuilder.create().texOffs(0, 72).addBox(-0.1f, -2.16f, -0.95f, 1.0f, 5.0f, 8.0f, cubeDef), PartPose.rotation((float)0.9599f, (float)0.0f, (float)1.8675f));
        PartDefinition tailFront = body.addOrReplaceChild("tail_front", CubeListBuilder.create().texOffs(38, 0).addBox(-3.0f, -3.0f, -1.0f, 6.0f, 6.0f, 11.0f, cubeDef), PartPose.offset((float)0.0f, (float)1.0f, (float)12.0f));
        PartDefinition tailHind = tailFront.addOrReplaceChild("tail_hind", CubeListBuilder.create().texOffs(27, 29).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)0.0f, (float)10.0f));
        PartDefinition tailFin = tailHind.addOrReplaceChild("tail_fin", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.5f, (float)9.0f));
        tailFin.addOrReplaceChild("tail_fin_down", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -2.0f, 0.0f, 1.0f, 3.0f, 8.0f, cubeDef), PartPose.offsetAndRotation((float)-0.5f, (float)0.35f, (float)1.0f, (float)-0.3926991f, (float)0.0f, (float)0.0f));
        tailFin.addOrReplaceChild("tail_fin_up", CubeListBuilder.create().texOffs(6, 73).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 4.0f, 12.0f, cubeDef), PartPose.offsetAndRotation((float)0.0f, (float)0.35f, (float)1.0f, (float)0.3926991f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void prepareMobModel(EntityLiopleurodon entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        super.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, ageInTicks);
        int l = entity.getAttackTick();
        float f = (float)l - ageInTicks;
        if (l > 0) {
            this.lowerJaw.xRot = l > 5 ? Mth.sin((float)(f / 4.0f - 1.0f)) * (float)Math.PI * 0.4f : 0.15707964f * Mth.sin((float)((float)Math.PI * f / 10.0f));
            this.upperJaw.xRot = -this.lowerJaw.xRot;
        } else {
            this.upperJaw.xRot = 0.0f;
            this.lowerJaw.xRot = 0.0f;
        }
    }

    public void setupAnim(EntityLiopleurodon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.xRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        this.body.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightFinFront.zRot = this.leftFinHind.zRot = -Mth.sin((float)(10.0f * ageInTicks / 57.295776f)) * 0.3f;
        this.leftFinFront.zRot = this.rightFinHind.zRot = -this.rightFinFront.zRot;
        if (entity.getDeltaMovement().horizontalDistanceSqr() > 1.0E-7) {
            this.head.xRot = Mth.cos((float)(limbSwing * 0.2f)) * limbSwingAmount / 8.0f;
            this.body.xRot += -0.05f - 0.05f * Mth.cos((float)(ageInTicks * 0.3f));
            this.tailFront.xRot = this.tailHind.xRot = -0.1f * Mth.cos((float)(ageInTicks * 0.3f));
            this.tailFin.xRot = -0.2f * Mth.cos((float)(ageInTicks * 0.3f));
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

