/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.nether.EntityScorcher;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;

public class ModelScorcher
extends EntityModel<EntityScorcher> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("scorcher");
    public final ModelPart Body;
    public final ModelPart Rods;
    public final ModelPart BackRod;
    public final ModelPart FrontRod;
    public final ModelPart RightRod;
    public final ModelPart LeftRod;

    public ModelScorcher(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Rods = root.getChild("Rods");
        this.BackRod = this.Rods.getChild("BackRod");
        this.FrontRod = this.Rods.getChild("FrontRod");
        this.RightRod = this.Rods.getChild("RightRod");
        this.LeftRod = this.Rods.getChild("LeftRod");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartPose zPose = PartPose.ZERO;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, cubeDef), PartPose.rotation((float)0.0f, (float)3.1416f, (float)0.0f));
        Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDef).texOffs(30, 0).addBox(-8.0f, -7.0f, -1.0f, 4.0f, 2.0f, 2.0f, cubeDef).texOffs(0, 20).addBox(-8.0f, -13.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDef).texOffs(30, 4).addBox(4.0f, -7.0f, -1.0f, 4.0f, 2.0f, 2.0f, cubeDef).texOffs(0, 0).addBox(6.0f, -13.0f, -1.0f, 2.0f, 6.0f, 2.0f, cubeDef), PartPose.offset((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition Rods = partdefinition.addOrReplaceChild("Rods", CubeListBuilder.create(), zPose);
        Rods.addOrReplaceChild("BackRod", CubeListBuilder.create().texOffs(8, 36).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubeDef), zPose);
        Rods.addOrReplaceChild("FrontRod", CubeListBuilder.create().texOffs(32, 20).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubeDef), zPose);
        Rods.addOrReplaceChild("RightRod", CubeListBuilder.create().texOffs(0, 36).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubeDef), zPose);
        Rods.addOrReplaceChild("LeftRod", CubeListBuilder.create().texOffs(30, 34).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 12.0f, 2.0f, cubeDef), zPose);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityScorcher entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks * (float)Math.PI * -0.1f;
        float f1 = f + 1.5707964f;
        for (int i = 0; i < 4; ++i) {
            float f2 = (float)(i * 2) + ageInTicks;
            this.Body.y = -Mth.cos((float)(f2 * 0.25f)) + 21.0f;
            this.BackRod.y = Mth.cos((float)(f2 * 0.25f)) + 16.0f;
            this.BackRod.x = -Mth.sin((float)f) * 9.0f;
            this.BackRod.z = -Mth.cos((float)f) * 9.0f;
            this.FrontRod.y = Mth.cos((float)(f2 * 0.15f)) + 16.0f;
            this.FrontRod.x = Mth.sin((float)f) * 9.0f;
            this.FrontRod.z = Mth.cos((float)f) * 9.0f;
            this.LeftRod.y = Mth.cos((float)(f2 * 0.2f)) + 16.0f;
            this.LeftRod.x = Mth.sin((float)f1) * 9.0f;
            this.LeftRod.z = Mth.cos((float)f1) * 9.0f;
            this.RightRod.y = Mth.cos((float)(f2 * 0.1f)) + 16.0f;
            this.RightRod.x = -Mth.sin((float)f1) * 9.0f;
            this.RightRod.z = -Mth.cos((float)f1) * 9.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.Rods.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

