/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;

public class ModelStoneGolem<T extends TamableAnimal>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("stone_golem");
    private final ModelPart body;
    private final ModelPart ring;
    private final ModelPart core;
    private final ModelPart ring2;
    private final ModelPart Head;
    private final ModelPart arm0;
    private final ModelPart arm1;

    public ModelStoneGolem(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.ring = this.body.getChild("ring");
        this.core = this.ring.getChild("core");
        this.ring2 = this.ring.getChild("ring2");
        this.Head = this.body.getChild("Head");
        this.arm0 = this.body.getChild("arm0");
        this.arm1 = this.body.getChild("arm1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, 3.0f, -6.0f, 18.0f, 12.0f, 11.0f, CubeDeformation.NONE).texOffs(0, 39).addBox(-4.5f, 15.0f, -3.5f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)).texOffs(54, 35).addBox(-4.5f, 15.0f, -3.5f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.6f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition ring = body.addOrReplaceChild("ring", CubeListBuilder.create().texOffs(73, 24).addBox(-5.5f, 1.0f, -5.5f, 10.0f, 1.0f, 10.0f, CubeDeformation.NONE).texOffs(54, 0).addBox(-8.5f, 1.5f, -8.5f, 16.0f, 0.0f, 16.0f, CubeDeformation.NONE), PartPose.offset((float)0.5f, (float)23.0f, (float)0.5f));
        ring.addOrReplaceChild("core", CubeListBuilder.create().texOffs(25, 48).addBox(-3.0f, -3.0f, -3.0f, 5.0f, 5.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        ring.addOrReplaceChild("ring2", CubeListBuilder.create().texOffs(83, 46).addBox(-3.0f, 1.0f, -3.0f, 6.0f, 1.0f, 6.0f, CubeDeformation.NONE).texOffs(90, 0).addBox(-6.0f, 1.5f, -6.0f, 12.0f, 0.0f, 12.0f, CubeDeformation.NONE), PartPose.offset((float)-0.5f, (float)5.0f, (float)-0.5f));
        PartDefinition Head = body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -6.0f, -6.5f, 8.0f, 8.0f, 8.0f, CubeDeformation.NONE).texOffs(32, 23).addBox(-4.5f, 2.0f, -7.5f, 9.0f, 2.0f, 9.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        Head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 66).mirror().addBox(0.0f, -4.0f, -1.5f, 3.0f, 5.0f, 5.0f, CubeDeformation.NONE).mirror(false).texOffs(16, 66).mirror().addBox(0.1f, -7.0f, 1.5f, 2.0f, 7.0f, 4.0f, CubeDeformation.NONE).mirror(false).texOffs(16, 66).addBox(-10.1f, -7.0f, 1.5f, 2.0f, 7.0f, 4.0f, CubeDeformation.NONE).texOffs(0, 66).addBox(-11.0f, -4.0f, -1.5f, 3.0f, 5.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)4.0f, (float)-2.0f, (float)-2.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("arm0", CubeListBuilder.create().texOffs(30, 34).addBox(-15.0f, 2.5f, -3.0f, 6.0f, 8.0f, 6.0f, CubeDeformation.NONE).texOffs(0, 50).addBox(-16.0f, 10.5f, -2.0f, 6.0f, 10.0f, 6.0f, CubeDeformation.NONE).texOffs(58, 8).addBox(-12.0f, 20.5f, -1.0f, 2.0f, 3.0f, 3.0f, CubeDeformation.NONE).texOffs(58, 0).addBox(-16.0f, 20.5f, -1.0f, 2.0f, 4.0f, 4.0f, CubeDeformation.NONE).texOffs(45, 48).addBox(-12.0f, 20.5f, -1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.1f)).texOffs(55, 46).addBox(-16.0f, 20.5f, -1.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(30, 34).mirror().addBox(9.0f, 2.5f, -3.0f, 6.0f, 8.0f, 6.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 50).mirror().addBox(10.0f, 10.5f, -2.0f, 6.0f, 10.0f, 6.0f, CubeDeformation.NONE).mirror(false).texOffs(58, 8).mirror().addBox(10.0f, 20.5f, -1.0f, 2.0f, 3.0f, 3.0f, CubeDeformation.NONE).mirror(false).texOffs(45, 48).mirror().addBox(10.0f, 20.5f, -1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.1f)).mirror(false).texOffs(58, 0).mirror().addBox(14.0f, 20.5f, -1.0f, 2.0f, 4.0f, 4.0f, CubeDeformation.NONE).mirror(false).texOffs(55, 46).mirror().addBox(14.0f, 20.5f, -1.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.ring.yRot = ageInTicks * 0.2f;
        this.core.yRot = -0.5f * this.ring.yRot;
        this.ring2.yRot = -2.0f * this.ring.yRot;
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        float f = Mth.sin((float)(ageInTicks * 0.08f));
        this.arm0.y = this.arm1.y = 2.0f + f * 0.3f;
        this.body.y = -17.0f + f * 0.2f;
        this.ring.y = 23.0f - f * 0.25f;
        if (((TamableAnimal)entity).swinging) {
            this.arm0.xRot = this.arm1.xRot = Mth.sin((float)(((float)((TamableAnimal)entity).swingTime + ageInTicks - (float)Mth.floor((float)ageInTicks)) * (float)Math.PI / (float)entity.getCurrentSwingDuration())) * -1.5707964f;
        } else {
            this.arm1.xRot = 0.0f;
            this.arm0.xRot = 0.0f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

