/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityTheGrue;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelTheGrue
extends EntityModel<EntityTheGrue> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("the_grue");
    public final ModelPart Body;
    public final ModelPart Tail;
    public final ModelPart Head;
    public final ModelPart RightJaw;
    public final ModelPart LeftJaw;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelTheGrue(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.Tail = this.Body.getChild("Tail");
        this.Head = this.Body.getChild("Head");
        this.LeftJaw = this.Head.getChild("LeftJaw");
        this.RightJaw = this.Head.getChild("RightJaw");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        CubeDeformation cubeDef = CubeDeformation.NONE;
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -3.0f, 0.0f, 10.0f, 14.0f, 15.0f, cubeDef), PartPose.offset((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)15.0f));
        PartDefinition UpperTail = Tail.addOrReplaceChild("UpperTail", CubeListBuilder.create().texOffs(64, 63).addBox(-3.0f, -4.0f, 0.0f, 6.0f, 6.0f, 6.0f, cubeDef), PartPose.ZERO);
        PartDefinition MiddleTail = UpperTail.addOrReplaceChild("MiddleTail", CubeListBuilder.create().texOffs(40, 63).addBox(-3.0f, -4.0f, 0.0f, 6.0f, 6.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        MiddleTail.addOrReplaceChild("LowerTail", CubeListBuilder.create().texOffs(16, 63).addBox(-3.0f, -4.0f, 0.0f, 6.0f, 6.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(32, 29).addBox(-4.0f, -7.0f, -16.0f, 8.0f, 6.0f, 8.0f, cubeDef).texOffs(0, 29).addBox(-4.0f, -7.0f, -8.0f, 8.0f, 11.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)1.0f, (float)0.01f));
        Head.addOrReplaceChild("RightJaw", CubeListBuilder.create().texOffs(62, 35).addBox(-4.0f, -0.5f, -8.0f, 4.0f, 5.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)-0.5f, (float)-8.0f));
        Head.addOrReplaceChild("LeftJaw", CubeListBuilder.create().texOffs(56, 17).addBox(0.0f, -0.5f, -8.0f, 4.0f, 5.0f, 8.0f, cubeDef), PartPose.offset((float)0.0f, (float)-0.5f, (float)-8.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(23, 43).addBox(-5.0f, -6.0f, -5.0f, 3.0f, 11.0f, 9.0f, cubeDef), PartPose.offset((float)-2.99f, (float)7.99f, (float)7.0f));
        RightLeg.addOrReplaceChild("RightFoot", CubeListBuilder.create().texOffs(50, 0).addBox(-1.5f, 0.0f, -3.0f, 5.0f, 11.0f, 6.0f, cubeDef), PartPose.offset((float)-3.0f, (float)5.0f, (float)-2.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(47, 43).addBox(5.0f, -6.0f, -5.0f, 3.0f, 11.0f, 9.0f, cubeDef), PartPose.offset((float)-0.01f, (float)7.99f, (float)7.0f));
        LeftLeg.addOrReplaceChild("LeftFoot", CubeListBuilder.create().texOffs(0, 48).addBox(-3.5f, 0.0f, -3.0f, 5.0f, 11.0f, 6.0f, cubeDef), PartPose.offset((float)6.0f, (float)5.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void prepareMobModel(EntityTheGrue entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTick);
        int l = entity.getAttackTick();
        if (l > 0) {
            if (l > 5) {
                this.RightJaw.xRot = this.RightJaw.yRot = Mth.sin((float)(((float)(-4 + l) - partialTick) / 4.0f)) * (float)Math.PI * 0.4f + 0.1309f;
                this.LeftJaw.xRot = this.RightJaw.yRot;
            } else {
                this.RightJaw.xRot = this.RightJaw.yRot = 0.1571f * Mth.sin((float)((float)Math.PI * ((float)l - partialTick) / 10.0f));
                this.LeftJaw.xRot = this.RightJaw.yRot;
            }
        } else {
            this.RightJaw.xRot = this.RightJaw.yRot = Mth.sqrt((float)((float)Math.atan(200.0f * limbSwing) / 3.0f)) * limbSwingAmount + 0.1309f;
            this.LeftJaw.xRot = this.RightJaw.yRot;
        }
    }

    public void setupAnim(EntityTheGrue entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.LeftJaw.yRot = -this.LeftJaw.xRot;
        float f = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        float f1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.Body.zRot = f1 * 0.05f;
        this.Tail.yRot = f * 0.4f;
        this.Tail.xRot = f * 0.1f;
        this.RightLeg.xRot = f * 1.4f;
        this.LeftLeg.xRot = f1;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.RightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.LeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

