/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.overworld.EntityWhale;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;

public class ModelWhale
extends EntityModel<EntityWhale> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("whale");
    private final ModelPart body;
    private final ModelPart flipperL;
    private final ModelPart flipperR;
    private final ModelPart tail;

    public ModelWhale(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.body = root.getChild("body");
        this.flipperL = root.getChild("flipperL");
        this.flipperR = root.getChild("flipperR");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, 0.0f, 8.0f, 6.0f, 24.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-4.0f, (float)18.0f, (float)-9.0f));
        partdefinition.addOrReplaceChild("flipperL", CubeListBuilder.create().texOffs(0, 42).mirror().addBox(0.0f, 0.0f, -3.0f, 6.0f, 2.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)3.0f, (float)21.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("flipperR", CubeListBuilder.create().texOffs(0, 42).mirror().addBox(-6.0f, 0.0f, -3.0f, 6.0f, 2.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)-3.0f, (float)21.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 58).mirror().addBox(-6.0f, 0.0f, 6.0f, 12.0f, 2.0f, 4.0f, CubeDeformation.NONE).mirror(false).texOffs(0, 42).mirror().addBox(-3.0f, 0.0f, 0.0f, 6.0f, 2.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offset((float)0.0f, (float)19.0f, (float)15.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(EntityWhale entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.flipperR.zRot = (float)(-Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.flipperL.zRot = (float)(Math.sin((double)(10.0f * ageInTicks) / 57.29577951308232) * (double)0.3f);
        this.tail.xRot = (float)(Math.cos(limbSwing * 0.6662f) * (double)limbSwingAmount / 4.0);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.flipperL.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.flipperR.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

