/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vanilla;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.vanilla.nether.EntityWildfire;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;

public class ModelWildfire
extends HumanoidModel<EntityWildfire> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("wildfire");
    public final ModelPart rightAntenna;
    public final ModelPart leftAntenna;
    public final ModelPart hip;
    public final ModelPart thorax;

    public ModelWildfire(ModelPart part) {
        super(part);
        this.rightAntenna = this.head.getChild("right_antenna");
        this.leftAntenna = this.head.getChild("left_antenna");
        this.hip = this.body.getChild("hip");
        this.thorax = this.hip.getChild("thorax");
    }

    public static LayerDefinition createBodyLayer() {
        CubeDeformation cubeDef = CubeDeformation.NONE;
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)cubeDef, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartPose zPose = PartPose.ZERO;
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 25).addBox(-3.0f, -4.0f, -4.0f, 6.0f, 7.0f, 6.0f, cubeDef), PartPose.offset((float)0.0f, (float)0.0f, (float)-1.0f));
        PartDefinition rightAntenna = head.addOrReplaceChild("right_antenna", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-3.99f, (float)1.5f));
        rightAntenna.addOrReplaceChild("right_antenna_rot", CubeListBuilder.create().texOffs(20, 43).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, cubeDef).texOffs(36, 21).addBox(-0.5f, -4.0f, -2.5f, 1.0f, 1.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.2617994f, (float)0.0f));
        PartDefinition leftAntenna = head.addOrReplaceChild("left_antenna", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-3.99f, (float)1.5f));
        leftAntenna.addOrReplaceChild("left_antenna_rot", CubeListBuilder.create().texOffs(20, 38).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, cubeDef).texOffs(30, 21).addBox(-0.5f, -4.0f, -2.5f, 1.0f, 1.0f, 2.0f, cubeDef), PartPose.rotation((float)0.0f, (float)-0.2617994f, (float)0.0f));
        head.addOrReplaceChild("right_mandible", CubeListBuilder.create().texOffs(46, 0).addBox(-0.5f, -2.75f, -2.0f, 2.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)-3.0f, (float)2.0f, (float)-2.5f));
        head.addOrReplaceChild("left_mandible", CubeListBuilder.create().texOffs(36, 0).addBox(-1.5f, -2.75f, -2.0f, 2.0f, 4.0f, 3.0f, cubeDef), PartPose.offset((float)3.0f, (float)2.0f, (float)-2.5f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 13).addBox(-5.0f, -7.0f, -3.0f, 10.0f, 7.0f, 5.0f, cubeDef), zPose);
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), zPose);
        PartDefinition rightArmRot = rightArm.addOrReplaceChild("right_arm_rot", CubeListBuilder.create().texOffs(10, 38).addBox(-2.0f, -3.0f, -1.5f, 2.0f, 14.0f, 3.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.1308997f));
        rightArmRot.addOrReplaceChild("right_claw", CubeListBuilder.create().texOffs(36, 7).addBox(0.0f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, cubeDef), PartPose.offset((float)-2.0f, (float)11.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), zPose);
        PartDefinition leftArmRot = leftArm.addOrReplaceChild("left_arm_rot", CubeListBuilder.create().texOffs(0, 38).addBox(0.0f, -3.0f, -1.5f, 2.0f, 14.0f, 3.0f, cubeDef), PartPose.rotation((float)0.0f, (float)0.0f, (float)-0.1308997f));
        leftArmRot.addOrReplaceChild("left_claw", CubeListBuilder.create().texOffs(48, 7).addBox(-3.0f, 0.0f, -1.5f, 3.0f, 2.0f, 3.0f, cubeDef), PartPose.offset((float)2.0f, (float)11.0f, (float)0.0f));
        PartDefinition hip = body.addOrReplaceChild("hip", CubeListBuilder.create().texOffs(24, 25).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 7.0f, 4.0f, cubeDef), zPose);
        PartDefinition thorax = hip.addOrReplaceChild("thorax", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)1.0f));
        thorax.addOrReplaceChild("thorax_rot", CubeListBuilder.create().texOffs(30, 13).addBox(-4.0f, -2.0f, 8.0f, 8.0f, 4.0f, 4.0f, cubeDef).texOffs(0, 0).addBox(-5.0f, -3.0f, 0.0f, 10.0f, 5.0f, 8.0f, cubeDef), PartPose.rotation((float)-0.6109f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(24, 36).addBox(-2.0f, 0.0f, -1.0f, 3.0f, 12.0f, 3.0f, cubeDef), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(36, 36).addBox(-1.0f, 0.0f, -1.0f, 3.0f, 12.0f, 3.0f, cubeDef), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(EntityWildfire entity, float limbSwing, float limbSwingAmount, float ageInTicks) {
        this.rightArmPose = this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        if (entity.getMainHandItem().getItem() instanceof BowItem && entity.isAggressive()) {
            if (entity.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.prepareMobModel((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks);
    }

    public void setupAnim(EntityWildfire entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.rightAntenna.yRot = -Mth.cos((float)(ageInTicks * 0.05f + limbSwing * 0.5f)) * (0.08f + limbSwingAmount * 0.1f);
        this.leftAntenna.yRot = -this.rightAntenna.yRot;
        this.thorax.yRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount * 0.4f;
        this.hat.y = -2.0f;
        this.head.y = -2.0f;
        this.body.y = 5.0f;
        this.leftArm.y = 0.0f;
        this.rightArm.y = 0.0f;
        this.leftArm.z = -0.5f;
        this.rightArm.z = -0.5f;
        this.leftLeg.z = -1.0f;
        this.rightLeg.z = -1.0f;
    }

    public void translateToHand(HumanoidArm arm, PoseStack stack) {
        float f = arm == HumanoidArm.RIGHT ? -1.0f : 1.0f;
        ModelPart modelpart = this.getArm(arm);
        modelpart.x += f;
        modelpart.translateAndRotate(stack);
        modelpart.x -= f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

