/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.vethea;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.util.ClientUtils;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelAcidHag<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = ClientUtils.createLocation("acid_hag");
    private final ModelPart Body;
    private final ModelPart AcidTrail;
    private final ModelPart Hip;
    private final ModelPart Abs;
    private final ModelPart UpperBody;
    private final ModelPart NecklaceBottom;
    private final ModelPart RightArmEnd;
    private final ModelPart LeftArmEnd;
    private final ModelPart Neck;
    private final ModelPart Head;
    private final ModelPart Hair;
    private final ModelPart Jaw;

    public ModelAcidHag(EntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(LAYER_LOCATION);
        this.Body = root.getChild("Body");
        this.AcidTrail = this.Body.getChild("AcidTrail");
        this.Hip = this.Body.getChild("Hip");
        this.Abs = this.Hip.getChild("Abs");
        this.UpperBody = this.Abs.getChild("UpperBody");
        ModelPart Necklace = this.UpperBody.getChild("Necklace");
        this.NecklaceBottom = Necklace.getChild("NecklaceBottom");
        ModelPart LeftArm = this.UpperBody.getChild("LeftArm");
        this.LeftArmEnd = LeftArm.getChild("LeftArmEnd");
        ModelPart RightArm = this.UpperBody.getChild("RightArm");
        this.RightArmEnd = RightArm.getChild("RightArmEnd");
        this.Neck = this.UpperBody.getChild("Neck");
        this.Head = this.Neck.getChild("Head");
        this.Hair = this.Head.getChild("Hair");
        this.Jaw = this.Head.getChild("Jaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 18).addBox(-5.0f, -7.1756f, -3.9731f, 10.0f, 7.0f, 10.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)24.1756f, (float)-1.0269f));
        Body.addOrReplaceChild("AcidTrail", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, 0.0f, -5.0f, 14.0f, 0.0f, 18.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-0.2006f, (float)2.0269f));
        PartDefinition Hip = Body.addOrReplaceChild("Hip", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.1756f, (float)4.0269f));
        Hip.addOrReplaceChild("hip_r1", CubeListBuilder.create().texOffs(38, 35).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 10.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition Abs = Hip.addOrReplaceChild("Abs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.9205f, (float)-4.6021f));
        Abs.addOrReplaceChild("abs_r1", CubeListBuilder.create().texOffs(40, 18).addBox(-3.0f, -8.0f, -3.0f, 6.0f, 10.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition UpperBody = Abs.addOrReplaceChild("UpperBody", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0795f, (float)-4.3979f));
        UpperBody.addOrReplaceChild("chest_r1", CubeListBuilder.create().texOffs(0, 35).addBox(-6.0f, -4.0f, -3.0f, 12.0f, 6.0f, 7.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Necklace = UpperBody.addOrReplaceChild("Necklace", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        Necklace.addOrReplaceChild("necklacetop_r1", CubeListBuilder.create().texOffs(20, 48).addBox(-4.0f, -5.0f, 0.0f, 8.0f, 5.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)-4.5f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        Necklace.addOrReplaceChild("NecklaceBottom", CubeListBuilder.create().texOffs(76, 47).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f, CubeDeformation.NONE).texOffs(76, 55).addBox(-1.0f, 7.0f, -1.0f, 2.0f, 2.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)1.5f, (float)-4.5f));
        PartDefinition LeftArm = UpperBody.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(40, 53).addBox(-0.25f, -0.939f, -1.8578f, 5.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)6.25f, (float)-3.061f, (float)-0.1422f));
        LeftArm.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(52, 66).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.75f, (float)15.9712f, (float)4.7634f, (float)0.8727f, (float)0.0f, (float)0.0f));
        LeftArm.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(64, 0).addBox(-1.5f, -2.0f, -2.0f, 4.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.75f, (float)9.0284f, (float)0.8001f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArmEnd = LeftArm.addOrReplaceChild("LeftArmEnd", CubeListBuilder.create(), PartPose.offset((float)1.75f, (float)20.0f, (float)10.84f));
        LeftArmEnd.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(64, 13).addBox(-1.5f, -2.0f, -2.0f, 4.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        LeftArmEnd.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(70, 39).addBox(-0.5f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)9.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = UpperBody.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(58, 53).addBox(-4.75f, -0.939f, -1.8578f, 5.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offset((float)-6.25f, (float)-3.061f, (float)-0.1422f));
        RightArm.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(20, 65).addBox(-1.5f, -2.0f, -2.0f, 4.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.75f, (float)9.0284f, (float)0.8001f, (float)0.4363f, (float)0.0f, (float)0.0f));
        RightArm.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(66, 66).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.75f, (float)15.9712f, (float)4.7634f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition RightArmEnd = RightArm.addOrReplaceChild("RightArmEnd", CubeListBuilder.create(), PartPose.offset((float)-2.75f, (float)20.0f, (float)10.84f));
        RightArmEnd.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 73).addBox(-2.5f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)7.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        RightArmEnd.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(36, 66).addBox(-1.5f, -2.0f, -2.0f, 4.0f, 9.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition Neck = UpperBody.addOrReplaceChild("Neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)-2.0f));
        Neck.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(70, 26).addBox(-1.0f, -8.0f, -2.0f, 3.0f, 10.0f, 3.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-0.5f, (float)-2.0f, (float)-1.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(20, 53).addBox(-2.5f, -2.75f, -4.5f, 5.0f, 5.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-6.25f, (float)-5.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        Head.addOrReplaceChild("Hair", CubeListBuilder.create().texOffs(0, 48).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 20.0f, 5.0f, new CubeDeformation(0.3f)), PartPose.offset((float)0.0f, (float)-0.75f, (float)-2.0f));
        PartDefinition Jaw = Head.addOrReplaceChild("Jaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        Jaw.addOrReplaceChild("jaw_r1", CubeListBuilder.create().texOffs(81, 0).addBox(-2.0f, -1.342f, -3.9397f, 4.0f, 3.0f, 4.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rot = (Mth.cos((float)(limbSwing * 0.6662f)) - 1.0f) * limbSwingAmount * 0.25f;
        this.Head.yRot = netHeadYaw * 0.6f * ((float)Math.PI / 180);
        this.Neck.yRot = netHeadYaw * 0.4f * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * 0.6f * ((float)Math.PI / 180);
        this.Neck.xRot = rot * 0.25f;
        this.Abs.xRot = this.Hip.xRot = -this.Neck.xRot;
        this.UpperBody.xRot = this.Hip.xRot;
        this.Neck.xRot += headPitch * 0.4f * ((float)Math.PI / 180);
        this.RightArmEnd.xRot = this.Hair.xRot = rot * 0.9f;
        this.LeftArmEnd.xRot = this.Hair.xRot;
        this.NecklaceBottom.xRot = rot * 0.75f + Mth.sin((float)(limbSwing * 0.6662f)) * Mth.cos((float)(limbSwing * 4.0f * 0.6662f)) * limbSwingAmount * 0.5f;
        this.Jaw.xRot = Mth.cos((float)ageInTicks) * 0.1f;
        this.AcidTrail.zScale = 1.0f - rot;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

