/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticlePortal
extends TextureSheetParticle {
    SpriteSet animatedSprite;
    private final float portalParticleScale;

    public ParticlePortal(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed, float r, float g, float b, SpriteSet sprite) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, 1.0f, r, g, b, sprite);
    }

    public ParticlePortal(ClientLevel worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed, float scale, float r, float g, float b, SpriteSet sprite) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed);
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.lifetime = (int)(32.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime = (int)((double)this.lifetime * 0.5);
        this.portalParticleScale = this.quadSize;
        this.x = xCoordIn;
        this.y = yCoordIn;
        this.z = zCoordIn;
        this.rCol = r;
        this.gCol = g;
        this.bCol = b;
        this.animatedSprite = sprite;
    }

    protected int getLightColor(float partialTick) {
        int var2 = super.getLightColor(partialTick);
        float var3 = (float)this.age / (float)this.lifetime;
        var3 *= var3;
        var3 *= var3;
        int var4 = var2 & 0xFF;
        int var5 = var2 >> 16 & 0xFF;
        if ((var5 += (int)(var3 * 15.0f * 16.0f)) > 240) {
            var5 = 240;
        }
        return var4 | var5 << 16;
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var8 = ((float)this.age + partialTicks) / (float)this.lifetime * 2.0f;
        var8 = 1.0f - var8;
        var8 *= var8;
        var8 = 1.0f - var8;
        this.quadSize = this.portalParticleScale * var8;
        super.render(buffer, renderInfo, partialTicks);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TwilightProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public TwilightProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            ParticlePortal particle = new ParticlePortal(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, world.random.nextFloat() * 0.6f + 0.2f, 0.0f, 0.0f, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HaliteProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public HaliteProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            ParticlePortal particle = new ParticlePortal(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, 0.0f, world.random.nextFloat() * 0.6f + 0.3f, 0.3f, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MortumProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public MortumProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            float f = world.random.nextFloat() * 0.4f + 0.1f;
            ParticlePortal particle = new ParticlePortal(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, f, f, f, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SkythernProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public SkythernProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            float f = world.random.nextFloat() * 0.1f + 0.8f;
            ParticlePortal particle = new ParticlePortal(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, f, f, f, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ApalachiaProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public ApalachiaProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            ParticlePortal particle = new ParticlePortal(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, world.random.nextFloat() * 0.6f + 0.4f, 0.0f, 0.87f, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WildwoodProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public WildwoodProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            ParticlePortal particle = new ParticlePortal(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, 0.0f, world.random.nextFloat() * 0.6f + 0.4f, 1.0f, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EdenProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public EdenProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
            ParticlePortal particle = new ParticlePortal(world, xCoordIn, yCoordIn, zCoordIn, xSpeed, ySpeed, zSpeed, 0.95f, world.random.nextFloat() * 0.4f + 0.6f, 0.24f, this.sprites);
            particle.pickSprite(this.sprites);
            return particle;
        }
    }
}

