/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RiftParticle
extends TextureSheetParticle {
    final Vec3 origin;

    protected RiftParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.origin = new Vec3(x, y, z);
        Vec3 v = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).normalize();
        this.setParticleSpeed(v.x, v.y, v.z);
        this.lifetime = 60;
    }

    public void tick() {
        super.tick();
        if (this.age == 50) {
            this.setParticleSpeed(0.0, 0.0, 0.0);
        } else if (this.age > 50) {
            Vec3 dv = this.origin.subtract(this.x, this.y, this.z).scale(0.4);
            this.move(dv.x, dv.y, dv.z);
        } else {
            Vec3 dist = this.origin.subtract(this.x, this.y, this.z);
            Vec3 dv = new Vec3(this.xd * 0.5, this.yd * 0.5, this.zd * 0.5).add(dist.cross(new Vec3(0.0, -1.0, 0.0)).normalize()).add(dist.scale(0.5));
            this.setParticleSpeed(dv.x, dv.y, dv.z);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public static TextureSheetParticle createParticle(SimpleParticleType type, ClientLevel world, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeed, double ySpeed, double zSpeed) {
        return new RiftParticle(world, xCoordIn, yCoordIn, zCoordIn);
    }
}

