/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.base;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderDivineMob<T extends Mob>
extends MobRenderer<T, EntityModel<T>> {
    protected final ResourceLocation TEXTURE;
    protected final float scale;

    public RenderDivineMob(EntityRendererProvider.Context context, String name, EntityModel<T> model) {
        this(context, name, model, 1.0f);
    }

    public RenderDivineMob(EntityRendererProvider.Context context, String name, EntityModel<T> model, float shadowSize) {
        super(context, model, shadowSize);
        this.scale = 1.0f;
        this.TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("textures/entity/" + name + ".png"));
    }

    public RenderDivineMob(EntityRendererProvider.Context context, String name, EntityModel<T> model, float shadowSize, float scale) {
        super(context, model, shadowSize);
        this.scale = scale;
        this.TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("textures/entity/" + name + ".png"));
    }

    protected void scale(T type, PoseStack stack, float s) {
        if (type.isBaby()) {
            stack.scale(this.scale / 2.0f, this.scale / 2.0f, this.scale / 2.0f);
        } else {
            stack.scale(this.scale, this.scale, this.scale);
        }
    }

    public ResourceLocation getTextureLocation(T type) {
        return this.TEXTURE;
    }
}

