/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.entities.projectile.DivineFireball;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderDivineFireball<T extends DivineFireball>
extends EntityRenderer<T> {
    protected final ResourceLocation TEXTURE;
    protected final RenderType renderType;

    public RenderDivineFireball(EntityRendererProvider.Context context, String name) {
        this(context, ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("textures/projectiles/" + name + ".png")));
    }

    public RenderDivineFireball(EntityRendererProvider.Context context, ResourceLocation texture) {
        super(context);
        this.TEXTURE = texture;
        this.renderType = RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
        super.render(entity, yaw, partialTicks, matrix, buffer, packedLight);
        matrix.pushPose();
        matrix.scale(0.5f, 0.5f, 0.5f);
        matrix.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose matrixEntry = matrix.last();
        Matrix4f matrix4f = matrixEntry.pose();
        Matrix3f normal = matrixEntry.normal();
        VertexConsumer vertexBuilder = buffer.getBuffer(this.renderType);
        RenderDivineFireball.pos(vertexBuilder, matrix4f, normal, packedLight, 0.0f, 0.0f, 0.0f, 1.0f);
        RenderDivineFireball.pos(vertexBuilder, matrix4f, normal, packedLight, 1.0f, 0.0f, 1.0f, 1.0f);
        RenderDivineFireball.pos(vertexBuilder, matrix4f, normal, packedLight, 1.0f, 1.0f, 1.0f, 0.0f);
        RenderDivineFireball.pos(vertexBuilder, matrix4f, normal, packedLight, 0.0f, 1.0f, 0.0f, 0.0f);
        matrix.popPose();
    }

    private static void pos(VertexConsumer vertexBuilder, Matrix4f matrix4f, Matrix3f normal, int lightmapUV, float x, float y, float u, float v) {
        vertexBuilder.addVertex(matrix4f, x - 0.5f, y - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(lightmapUV).setNormal(0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.TEXTURE;
    }
}

