/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.items.base.ItemDivineShield;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class DivineShieldRenderer
extends BlockEntityWithoutLevelRenderer {
    private final ShieldModel model;

    public DivineShieldRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet set) {
        super(dispatcher, set);
        this.model = new ShieldModel(set.bakeLayer(ModelLayers.SHIELD));
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext context, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        super.renderByItem(stack, context, poseStack, buffer, packedLight, packedOverlay);
        Item item = stack.getItem();
        if (item instanceof ItemDivineShield) {
            poseStack.pushPose();
            poseStack.scale(1.0f, -1.0f, -1.0f);
            Material material = new Material(Sheets.SHIELD_SHEET, ((ItemDivineShield)item).resource);
            VertexConsumer vertexConsumer = material.sprite().wrap(ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)RenderType.entityCutout((ResourceLocation)material.atlasLocation()), (boolean)true, (boolean)stack.hasFoil()));
            this.model.handle().render(poseStack, vertexConsumer, packedLight, packedOverlay);
            this.model.plate().render(poseStack, vertexConsumer, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

