/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import divinerpg.blocks.base.BlockStatue;
import divinerpg.client.models.boss.ModelAncientEntity;
import divinerpg.client.models.boss.ModelAyeraco;
import divinerpg.client.models.boss.ModelDensos;
import divinerpg.client.models.boss.ModelDramix;
import divinerpg.client.models.boss.ModelEternalArcher;
import divinerpg.client.models.boss.ModelExperiencedCori;
import divinerpg.client.models.boss.ModelKarot;
import divinerpg.client.models.boss.ModelKingOfScorchers;
import divinerpg.client.models.boss.ModelKitra;
import divinerpg.client.models.boss.ModelParasecta;
import divinerpg.client.models.boss.ModelSoulFiend;
import divinerpg.client.models.boss.ModelSunstorm;
import divinerpg.client.models.boss.ModelTermasect;
import divinerpg.client.models.boss.ModelTwilightDemon;
import divinerpg.client.models.boss.ModelVamacheron;
import divinerpg.client.models.vanilla.ModelWatcher;
import divinerpg.registries.BlockRegistry;
import java.util.function.Supplier;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderItemStatue
extends BlockEntityWithoutLevelRenderer {
    EntityModelSet context;
    Supplier<Block> block;

    public RenderItemStatue(BlockEntityRenderDispatcher dispatcher, EntityModelSet set, Supplier<Block> block) {
        super(dispatcher, set);
        this.block = block;
        this.context = set;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext context, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Block block;
        if (stack.getItem() instanceof BlockItem && (block = ((BlockItem)stack.getItem()).getBlock()) instanceof BlockStatue) {
            Model model = this.getModel(stack);
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.8, 0.5);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStack.scale(0.6f, 0.6f, 0.6f);
            if (stack.is(((Block)BlockRegistry.kitraStatue.get()).asItem())) {
                matrixStack.scale(0.4f, 0.4f, 0.4f);
            }
            if (this.texture(stack) != null) {
                VertexConsumer builder = stack.is(((Block)BlockRegistry.kitraStatue.get()).asItem()) ? buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.texture(stack))) : buffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture(stack)));
                model.renderToBuffer(matrixStack, builder, combinedLight, combinedOverlay);
            }
            matrixStack.popPose();
        }
    }

    private Model getModel(ItemStack stack) {
        Item item = stack.getItem();
        if (item == BlockRegistry.ancientEntityStatue.asItem()) {
            return new ModelAncientEntity(this.context.bakeLayer(ModelAncientEntity.LAYER_LOCATION));
        }
        if (item == BlockRegistry.theWatcherStatue.asItem()) {
            return new ModelWatcher(this.context.bakeLayer(ModelWatcher.LAYER_LOCATION));
        }
        if (item == BlockRegistry.kingOfScorchersStatue.asItem()) {
            return new ModelKingOfScorchers(this.context.bakeLayer(ModelKingOfScorchers.LAYER_LOCATION));
        }
        if (item == BlockRegistry.kitraStatue.asItem()) {
            return new ModelKitra(this.context.bakeLayer(ModelKitra.LAYER_LOCATION));
        }
        if (item == BlockRegistry.ayeracoStatue.asItem()) {
            return new ModelAyeraco(this.context.bakeLayer(ModelAyeraco.LAYER_LOCATION));
        }
        if (item == BlockRegistry.dramixStatue.asItem()) {
            return new ModelDramix(this.context.bakeLayer(ModelDramix.LAYER_LOCATION));
        }
        if (item == BlockRegistry.parasectaStatue.asItem()) {
            return new ModelParasecta(this.context.bakeLayer(ModelParasecta.LAYER_LOCATION));
        }
        if (item == BlockRegistry.sunstormStatue.asItem()) {
            return new ModelSunstorm(this.context.bakeLayer(ModelSunstorm.LAYER_LOCATION));
        }
        if (item == BlockRegistry.termasectStatue.asItem()) {
            return new ModelTermasect(this.context.bakeLayer(ModelTermasect.LAYER_LOCATION));
        }
        if (item == BlockRegistry.eternalArcherStatue.asItem()) {
            return new ModelEternalArcher(this.context.bakeLayer(ModelEternalArcher.LAYER_LOCATION));
        }
        if (item == BlockRegistry.experiencedCoriStatue.asItem()) {
            return new ModelExperiencedCori(this.context.bakeLayer(ModelExperiencedCori.LAYER_LOCATION));
        }
        if (item == BlockRegistry.vamacheronStatue.asItem()) {
            return new ModelVamacheron(this.context.bakeLayer(ModelVamacheron.LAYER_LOCATION));
        }
        if (item == BlockRegistry.karotStatue.asItem()) {
            return new ModelKarot(this.context.bakeLayer(ModelKarot.LAYER_LOCATION));
        }
        if (item == BlockRegistry.twilightDemonStatue.asItem()) {
            return new ModelTwilightDemon(this.context.bakeLayer(ModelTwilightDemon.LAYER_LOCATION));
        }
        if (item == BlockRegistry.densosStatue.asItem()) {
            return new ModelDensos(this.context.bakeLayer(ModelDensos.LAYER_LOCATION));
        }
        if (item == BlockRegistry.reyvorStatue.asItem()) {
            return new ModelDensos(this.context.bakeLayer(ModelDensos.LAYER_LOCATION));
        }
        if (item == BlockRegistry.soulFiendStatue.asItem()) {
            return new ModelSoulFiend(this.context.bakeLayer(ModelSoulFiend.LAYER_LOCATION));
        }
        return new BookModel(this.context.bakeLayer(ModelLayers.BOOK));
    }

    private static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)("textures/entity/" + path + ".png"));
    }

    private ResourceLocation texture(ItemStack stack) {
        Item item = stack.getItem();
        if (item == BlockRegistry.ancientEntityStatue.asItem()) {
            return RenderItemStatue.location("ancient_entity");
        }
        if (item == BlockRegistry.kingOfScorchersStatue.asItem()) {
            return RenderItemStatue.location("king_of_scorchers");
        }
        if (item == BlockRegistry.theWatcherStatue.asItem()) {
            return RenderItemStatue.location("the_watcher");
        }
        if (item == BlockRegistry.kitraStatue.asItem()) {
            return RenderItemStatue.location("kitra");
        }
        if (item == BlockRegistry.ayeracoStatue.asItem()) {
            return RenderItemStatue.location("ayeraco_white");
        }
        if (item == BlockRegistry.dramixStatue.asItem()) {
            return RenderItemStatue.location("dramix");
        }
        if (item == BlockRegistry.parasectaStatue.asItem()) {
            return RenderItemStatue.location("parasecta");
        }
        if (item == BlockRegistry.sunstormStatue.asItem()) {
            return RenderItemStatue.location("sunstorm");
        }
        if (item == BlockRegistry.termasectStatue.asItem()) {
            return RenderItemStatue.location("termasect");
        }
        if (item == BlockRegistry.eternalArcherStatue.asItem()) {
            return RenderItemStatue.location("eternal_archer");
        }
        if (item == BlockRegistry.experiencedCoriStatue.asItem()) {
            return RenderItemStatue.location("experienced_cori");
        }
        if (item == BlockRegistry.vamacheronStatue.asItem()) {
            return RenderItemStatue.location("vamacheron");
        }
        if (item == BlockRegistry.karotStatue.asItem()) {
            return RenderItemStatue.location("karot");
        }
        if (item == BlockRegistry.twilightDemonStatue.asItem()) {
            return RenderItemStatue.location("twilight_demon");
        }
        if (item == BlockRegistry.densosStatue.asItem()) {
            return RenderItemStatue.location("densos");
        }
        if (item == BlockRegistry.reyvorStatue.asItem()) {
            return RenderItemStatue.location("reyvor");
        }
        if (item == BlockRegistry.soulFiendStatue.asItem()) {
            return RenderItemStatue.location("soul_fiend");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/block/black_hungerstone.png");
    }
}

