/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.renders.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import divinerpg.client.models.ModelHat;
import divinerpg.util.Utils;
import java.util.UUID;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerHatRender<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ModelHat<T> modelHat;
    private final ResourceLocation dev = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/devhats/hat_red.png");
    private final ResourceLocation tester = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/devhats/hat_blue.png");
    private final ResourceLocation artist = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/devhats/hat_purple.png");
    private final ResourceLocation special = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/devhats/hat_yellow.png");
    private final ResourceLocation friend = ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"textures/model/devhats/hat_pink.png");

    public PlayerHatRender(RenderLayerParent<T, M> parent, EntityModelSet set) {
        super(parent);
        this.modelHat = new ModelHat(set.bakeLayer(ModelHat.LAYER_LOCATION));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        UUID id = entity.getUUID();
        if (entity.getInventory().getArmor(3).isEmpty() && !entity.isInvisible() && entity.isModelPartShown(PlayerModelPart.HAT) && (Utils.isDeveloperName(id) || Utils.isTesterName(id) || Utils.isFriend(id) || Utils.isSpecial(id) || Utils.isArtist(id))) {
            this.modelHat.hat.copyFrom(((PlayerModel)this.getParentModel()).head);
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
            this.modelHat.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        UUID id = entity.getUUID();
        if (Utils.isSpecial(id)) {
            return this.special;
        }
        if (Utils.isTesterName(id)) {
            return this.tester;
        }
        if (Utils.isArtist(id)) {
            return this.artist;
        }
        if (Utils.isFriend(id)) {
            return this.friend;
        }
        return this.dev;
    }
}

